package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait RecurringChargeFrequency {
  def unwrap: software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency
}
object RecurringChargeFrequency {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency
  ): zio.aws.ec2.model.RecurringChargeFrequency = value match {
    case software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency.HOURLY =>
      val r = Hourly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.RecurringChargeFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency =
      software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object Hourly extends zio.aws.ec2.model.RecurringChargeFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency =
      software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency.HOURLY
  }
}
