package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionByoipCidrRequest(
    cidr: String,
    cidrAuthorizationContext: Option[
      zio.aws.ec2.model.CidrAuthorizationContext
    ] = None,
    publiclyAdvertisable: Option[Boolean] = None,
    description: Option[String] = None,
    poolTagSpecifications: Option[
      Iterable[zio.aws.ec2.model.TagSpecification]
    ] = None,
    multiRegion: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest = {
    import ProvisionByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .optionallyWith(
        cidrAuthorizationContext.map(value => value.buildAwsValue())
      )(_.cidrAuthorizationContext)
      .optionallyWith(
        publiclyAdvertisable.map(value => value: java.lang.Boolean)
      )(_.publiclyAdvertisable)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        poolTagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.poolTagSpecifications)
      .optionallyWith(multiRegion.map(value => value: java.lang.Boolean))(
        _.multiRegion
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionByoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.ProvisionByoipCidrRequest.wrap(buildAwsValue())
}
object ProvisionByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionByoipCidrRequest =
      zio.aws.ec2.model.ProvisionByoipCidrRequest(
        cidr,
        cidrAuthorizationContext.map(value => value.asEditable),
        publiclyAdvertisable.map(value => value),
        description.map(value => value),
        poolTagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiRegion.map(value => value)
      )
    def cidr: String
    def cidrAuthorizationContext
        : Option[zio.aws.ec2.model.CidrAuthorizationContext.ReadOnly]
    def publiclyAdvertisable: Option[Boolean]
    def description: Option[String]
    def poolTagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def multiRegion: Option[Boolean]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getCidrAuthorizationContext: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CidrAuthorizationContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cidrAuthorizationContext",
      cidrAuthorizationContext
    )
    def getPubliclyAdvertisable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAdvertisable", publiclyAdvertisable)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPoolTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("poolTagSpecifications", poolTagSpecifications)
    def getMultiRegion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiRegion", multiRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest
  ) extends zio.aws.ec2.model.ProvisionByoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val cidrAuthorizationContext
        : Option[zio.aws.ec2.model.CidrAuthorizationContext.ReadOnly] = scala
      .Option(impl.cidrAuthorizationContext())
      .map(value => zio.aws.ec2.model.CidrAuthorizationContext.wrap(value))
    override val publiclyAdvertisable: Option[Boolean] =
      scala.Option(impl.publiclyAdvertisable()).map(value => value: Boolean)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val poolTagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.poolTagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val multiRegion: Option[Boolean] =
      scala.Option(impl.multiRegion()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest
  ): zio.aws.ec2.model.ProvisionByoipCidrRequest.ReadOnly = new Wrapper(impl)
}
