package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PlacementGroupStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy
}
object PlacementGroupStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy
  ): zio.aws.ec2.model.PlacementGroupStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.CLUSTER =>
      val r = cluster
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.PARTITION =>
      val r = partition
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.SPREAD =>
      val r = spread
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object cluster extends zio.aws.ec2.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.CLUSTER
  }
  case object partition extends zio.aws.ec2.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.PARTITION
  }
  case object spread extends zio.aws.ec2.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy.SPREAD
  }
}
