package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PlacementGroup(
    groupName: Option[String] = None,
    state: Option[zio.aws.ec2.model.PlacementGroupState] = None,
    strategy: Option[zio.aws.ec2.model.PlacementStrategy] = None,
    partitionCount: Option[Integer] = None,
    groupId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    groupArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PlacementGroup = {
    import PlacementGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PlacementGroup
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(strategy.map(value => value.unwrap))(_.strategy)
      .optionallyWith(partitionCount.map(value => value: java.lang.Integer))(
        _.partitionCount
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(groupArn.map(value => value: java.lang.String))(
        _.groupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PlacementGroup.ReadOnly =
    zio.aws.ec2.model.PlacementGroup.wrap(buildAwsValue())
}
object PlacementGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PlacementGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PlacementGroup =
      zio.aws.ec2.model.PlacementGroup(
        groupName.map(value => value),
        state.map(value => value),
        strategy.map(value => value),
        partitionCount.map(value => value),
        groupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupArn.map(value => value)
      )
    def groupName: Option[String]
    def state: Option[zio.aws.ec2.model.PlacementGroupState]
    def strategy: Option[zio.aws.ec2.model.PlacementStrategy]
    def partitionCount: Option[Integer]
    def groupId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def groupArn: Option[String]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.PlacementGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getStrategy: ZIO[Any, AwsError, zio.aws.ec2.model.PlacementStrategy] =
      AwsError.unwrapOptionField("strategy", strategy)
    def getPartitionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionCount", partitionCount)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupArn", groupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PlacementGroup
  ) extends zio.aws.ec2.model.PlacementGroup.ReadOnly {
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.PlacementGroupState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.PlacementGroupState.wrap(value))
    override val strategy: Option[zio.aws.ec2.model.PlacementStrategy] = scala
      .Option(impl.strategy())
      .map(value => zio.aws.ec2.model.PlacementStrategy.wrap(value))
    override val partitionCount: Option[Integer] =
      scala.Option(impl.partitionCount()).map(value => value: Integer)
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val groupArn: Option[String] =
      scala.Option(impl.groupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PlacementGroup
  ): zio.aws.ec2.model.PlacementGroup.ReadOnly = new Wrapper(impl)
}
