package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PathComponent(
    sequenceNumber: Option[Integer] = None,
    aclRule: Option[zio.aws.ec2.model.AnalysisAclRule] = None,
    attachedTo: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    component: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    destinationVpc: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    outboundHeader: Option[zio.aws.ec2.model.AnalysisPacketHeader] = None,
    inboundHeader: Option[zio.aws.ec2.model.AnalysisPacketHeader] = None,
    routeTableRoute: Option[zio.aws.ec2.model.AnalysisRouteTableRoute] = None,
    securityGroupRule: Option[zio.aws.ec2.model.AnalysisSecurityGroupRule] =
      None,
    sourceVpc: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    subnet: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    vpc: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    additionalDetails: Option[Iterable[zio.aws.ec2.model.AdditionalDetail]] =
      None,
    transitGateway: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    transitGatewayRouteTableRoute: Option[
      zio.aws.ec2.model.TransitGatewayRouteTableRoute
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PathComponent = {
    import PathComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PathComponent
      .builder()
      .optionallyWith(sequenceNumber.map(value => value: java.lang.Integer))(
        _.sequenceNumber
      )
      .optionallyWith(aclRule.map(value => value.buildAwsValue()))(_.aclRule)
      .optionallyWith(attachedTo.map(value => value.buildAwsValue()))(
        _.attachedTo
      )
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(destinationVpc.map(value => value.buildAwsValue()))(
        _.destinationVpc
      )
      .optionallyWith(outboundHeader.map(value => value.buildAwsValue()))(
        _.outboundHeader
      )
      .optionallyWith(inboundHeader.map(value => value.buildAwsValue()))(
        _.inboundHeader
      )
      .optionallyWith(routeTableRoute.map(value => value.buildAwsValue()))(
        _.routeTableRoute
      )
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .optionallyWith(sourceVpc.map(value => value.buildAwsValue()))(
        _.sourceVpc
      )
      .optionallyWith(subnet.map(value => value.buildAwsValue()))(_.subnet)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .optionallyWith(
        additionalDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalDetails)
      .optionallyWith(transitGateway.map(value => value.buildAwsValue()))(
        _.transitGateway
      )
      .optionallyWith(
        transitGatewayRouteTableRoute.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTableRoute)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PathComponent.ReadOnly =
    zio.aws.ec2.model.PathComponent.wrap(buildAwsValue())
}
object PathComponent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PathComponent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PathComponent =
      zio.aws.ec2.model.PathComponent(
        sequenceNumber.map(value => value),
        aclRule.map(value => value.asEditable),
        attachedTo.map(value => value.asEditable),
        component.map(value => value.asEditable),
        destinationVpc.map(value => value.asEditable),
        outboundHeader.map(value => value.asEditable),
        inboundHeader.map(value => value.asEditable),
        routeTableRoute.map(value => value.asEditable),
        securityGroupRule.map(value => value.asEditable),
        sourceVpc.map(value => value.asEditable),
        subnet.map(value => value.asEditable),
        vpc.map(value => value.asEditable),
        additionalDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transitGateway.map(value => value.asEditable),
        transitGatewayRouteTableRoute.map(value => value.asEditable)
      )
    def sequenceNumber: Option[Integer]
    def aclRule: Option[zio.aws.ec2.model.AnalysisAclRule.ReadOnly]
    def attachedTo: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def component: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def destinationVpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def outboundHeader: Option[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly]
    def inboundHeader: Option[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly]
    def routeTableRoute
        : Option[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly]
    def securityGroupRule
        : Option[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly]
    def sourceVpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def subnet: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def additionalDetails
        : Option[List[zio.aws.ec2.model.AdditionalDetail.ReadOnly]]
    def transitGateway: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGatewayRouteTableRoute
        : Option[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly]
    def getSequenceNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
    def getAclRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      AwsError.unwrapOptionField("aclRule", aclRule)
    def getAttachedTo
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getDestinationVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("destinationVpc", destinationVpc)
    def getOutboundHeader
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] =
      AwsError.unwrapOptionField("outboundHeader", outboundHeader)
    def getInboundHeader
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] =
      AwsError.unwrapOptionField("inboundHeader", inboundHeader)
    def getRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField("routeTableRoute", routeTableRoute)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
    def getSourceVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("sourceVpc", sourceVpc)
    def getSubnet
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("subnet", subnet)
    def getVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getAdditionalDetails: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AdditionalDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("additionalDetails", additionalDetails)
    def getTransitGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("transitGateway", transitGateway)
    def getTransitGatewayRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableRoute",
      transitGatewayRouteTableRoute
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PathComponent
  ) extends zio.aws.ec2.model.PathComponent.ReadOnly {
    override val sequenceNumber: Option[Integer] =
      scala.Option(impl.sequenceNumber()).map(value => value: Integer)
    override val aclRule: Option[zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      scala
        .Option(impl.aclRule())
        .map(value => zio.aws.ec2.model.AnalysisAclRule.wrap(value))
    override val attachedTo
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.attachedTo())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val component
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.component())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val destinationVpc
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.destinationVpc())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val outboundHeader
        : Option[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] = scala
      .Option(impl.outboundHeader())
      .map(value => zio.aws.ec2.model.AnalysisPacketHeader.wrap(value))
    override val inboundHeader
        : Option[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] = scala
      .Option(impl.inboundHeader())
      .map(value => zio.aws.ec2.model.AnalysisPacketHeader.wrap(value))
    override val routeTableRoute
        : Option[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly] = scala
      .Option(impl.routeTableRoute())
      .map(value => zio.aws.ec2.model.AnalysisRouteTableRoute.wrap(value))
    override val securityGroupRule
        : Option[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly] = scala
      .Option(impl.securityGroupRule())
      .map(value => zio.aws.ec2.model.AnalysisSecurityGroupRule.wrap(value))
    override val sourceVpc
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.sourceVpc())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val subnet: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      scala
        .Option(impl.subnet())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      scala
        .Option(impl.vpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val additionalDetails
        : Option[List[zio.aws.ec2.model.AdditionalDetail.ReadOnly]] = scala
      .Option(impl.additionalDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AdditionalDetail.wrap(item)
        }.toList
      )
    override val transitGateway
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.transitGateway())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGatewayRouteTableRoute
        : Option[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly] =
      scala
        .Option(impl.transitGatewayRouteTableRoute())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayRouteTableRoute.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PathComponent
  ): zio.aws.ec2.model.PathComponent.ReadOnly = new Wrapper(impl)
}
