package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait OfferingTypeValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.OfferingTypeValues
}
object OfferingTypeValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.OfferingTypeValues
  ): zio.aws.ec2.model.OfferingTypeValues = value match {
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.HEAVY_UTILIZATION =>
      val r = `Heavy Utilization`
      r
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.MEDIUM_UTILIZATION =>
      val r = `Medium Utilization`
      r
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.LIGHT_UTILIZATION =>
      val r = `Light Utilization`
      r
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.NO_UPFRONT =>
      val r = `No Upfront`
      r
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.PARTIAL_UPFRONT =>
      val r = `Partial Upfront`
      r
    case software.amazon.awssdk.services.ec2.model.OfferingTypeValues.ALL_UPFRONT =>
      val r = `All Upfront`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object `Heavy Utilization` extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.HEAVY_UTILIZATION
  }
  case object `Medium Utilization`
      extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.MEDIUM_UTILIZATION
  }
  case object `Light Utilization` extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.LIGHT_UTILIZATION
  }
  case object `No Upfront` extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.NO_UPFRONT
  }
  case object `Partial Upfront` extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.PARTIAL_UPFRONT
  }
  case object `All Upfront` extends zio.aws.ec2.model.OfferingTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingTypeValues =
      software.amazon.awssdk.services.ec2.model.OfferingTypeValues.ALL_UPFRONT
  }
}
