package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInterfaceAssociation(
    allocationId: Option[String] = None,
    associationId: Option[String] = None,
    ipOwnerId: Option[String] = None,
    publicDnsName: Option[String] = None,
    publicIp: Option[String] = None,
    customerOwnedIp: Option[String] = None,
    carrierIp: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation = {
    import NetworkInterfaceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
      .builder()
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(ipOwnerId.map(value => value: java.lang.String))(
        _.ipOwnerId
      )
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(customerOwnedIp.map(value => value: java.lang.String))(
        _.customerOwnedIp
      )
      .optionallyWith(carrierIp.map(value => value: java.lang.String))(
        _.carrierIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly =
    zio.aws.ec2.model.NetworkInterfaceAssociation.wrap(buildAwsValue())
}
object NetworkInterfaceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfaceAssociation =
      zio.aws.ec2.model.NetworkInterfaceAssociation(
        allocationId.map(value => value),
        associationId.map(value => value),
        ipOwnerId.map(value => value),
        publicDnsName.map(value => value),
        publicIp.map(value => value),
        customerOwnedIp.map(value => value),
        carrierIp.map(value => value)
      )
    def allocationId: Option[String]
    def associationId: Option[String]
    def ipOwnerId: Option[String]
    def publicDnsName: Option[String]
    def publicIp: Option[String]
    def customerOwnedIp: Option[String]
    def carrierIp: Option[String]
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getIpOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipOwnerId", ipOwnerId)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getCustomerOwnedIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIp", customerOwnedIp)
    def getCarrierIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrierIp", carrierIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
  ) extends zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly {
    override val allocationId: Option[String] =
      scala.Option(impl.allocationId()).map(value => value: String)
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val ipOwnerId: Option[String] =
      scala.Option(impl.ipOwnerId()).map(value => value: String)
    override val publicDnsName: Option[String] =
      scala.Option(impl.publicDnsName()).map(value => value: String)
    override val publicIp: Option[String] =
      scala.Option(impl.publicIp()).map(value => value: String)
    override val customerOwnedIp: Option[String] =
      scala.Option(impl.customerOwnedIp()).map(value => value: String)
    override val carrierIp: Option[String] =
      scala.Option(impl.carrierIp()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
  ): zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly = new Wrapper(impl)
}
