package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, SpotFleetRequestId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifySpotFleetRequestRequest(
    excessCapacityTerminationPolicy: Option[
      zio.aws.ec2.model.ExcessCapacityTerminationPolicy
    ] = None,
    launchTemplateConfigs: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateConfig]
    ] = None,
    spotFleetRequestId: SpotFleetRequestId,
    targetCapacity: Option[Integer] = None,
    onDemandTargetCapacity: Option[Integer] = None,
    context: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest = {
    import ModifySpotFleetRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest
      .builder()
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .spotFleetRequestId(
        SpotFleetRequestId.unwrap(spotFleetRequestId): java.lang.String
      )
      .optionallyWith(targetCapacity.map(value => value: java.lang.Integer))(
        _.targetCapacity
      )
      .optionallyWith(
        onDemandTargetCapacity.map(value => value: java.lang.Integer)
      )(_.onDemandTargetCapacity)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySpotFleetRequestRequest.ReadOnly =
    zio.aws.ec2.model.ModifySpotFleetRequestRequest.wrap(buildAwsValue())
}
object ModifySpotFleetRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySpotFleetRequestRequest =
      zio.aws.ec2.model.ModifySpotFleetRequestRequest(
        excessCapacityTerminationPolicy.map(value => value),
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spotFleetRequestId,
        targetCapacity.map(value => value),
        onDemandTargetCapacity.map(value => value),
        context.map(value => value)
      )
    def excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.ExcessCapacityTerminationPolicy]
    def launchTemplateConfigs
        : Option[List[zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly]]
    def spotFleetRequestId: SpotFleetRequestId
    def targetCapacity: Option[Integer]
    def onDemandTargetCapacity: Option[Integer]
    def context: Option[String]
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getSpotFleetRequestId: ZIO[Any, Nothing, SpotFleetRequestId] =
      ZIO.succeed(spotFleetRequestId)
    def getTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetCapacity", targetCapacity)
    def getOnDemandTargetCapacity: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("onDemandTargetCapacity", onDemandTargetCapacity)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest
  ) extends zio.aws.ec2.model.ModifySpotFleetRequestRequest.ReadOnly {
    override val excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.ExcessCapacityTerminationPolicy] = scala
      .Option(impl.excessCapacityTerminationPolicy())
      .map(value =>
        zio.aws.ec2.model.ExcessCapacityTerminationPolicy.wrap(value)
      )
    override val launchTemplateConfigs
        : Option[List[zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly]] = scala
      .Option(impl.launchTemplateConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateConfig.wrap(item)
        }.toList
      )
    override val spotFleetRequestId: SpotFleetRequestId =
      zio.aws.ec2.model.primitives.SpotFleetRequestId(impl.spotFleetRequestId())
    override val targetCapacity: Option[Integer] =
      scala.Option(impl.targetCapacity()).map(value => value: Integer)
    override val onDemandTargetCapacity: Option[Integer] =
      scala.Option(impl.onDemandTargetCapacity()).map(value => value: Integer)
    override val context: Option[String] =
      scala.Option(impl.context()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest
  ): zio.aws.ec2.model.ModifySpotFleetRequestRequest.ReadOnly = new Wrapper(
    impl
  )
}
