package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifySnapshotTierRequest(
    snapshotId: SnapshotId,
    storageTier: Option[zio.aws.ec2.model.TargetStorageTier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest = {
    import ModifySnapshotTierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(storageTier.map(value => value.unwrap))(_.storageTier)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySnapshotTierRequest.ReadOnly =
    zio.aws.ec2.model.ModifySnapshotTierRequest.wrap(buildAwsValue())
}
object ModifySnapshotTierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySnapshotTierRequest =
      zio.aws.ec2.model
        .ModifySnapshotTierRequest(snapshotId, storageTier.map(value => value))
    def snapshotId: SnapshotId
    def storageTier: Option[zio.aws.ec2.model.TargetStorageTier]
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getStorageTier
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetStorageTier] =
      AwsError.unwrapOptionField("storageTier", storageTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest
  ) extends zio.aws.ec2.model.ModifySnapshotTierRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val storageTier: Option[zio.aws.ec2.model.TargetStorageTier] =
      scala
        .Option(impl.storageTier())
        .map(value => zio.aws.ec2.model.TargetStorageTier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest
  ): zio.aws.ec2.model.ModifySnapshotTierRequest.ReadOnly = new Wrapper(impl)
}
