package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifySecurityGroupRulesRequest(
    groupId: SecurityGroupId,
    securityGroupRules: Iterable[zio.aws.ec2.model.SecurityGroupRuleUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest = {
    import ModifySecurityGroupRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
      .builder()
      .groupId(SecurityGroupId.unwrap(groupId): java.lang.String)
      .securityGroupRules(securityGroupRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySecurityGroupRulesRequest.ReadOnly =
    zio.aws.ec2.model.ModifySecurityGroupRulesRequest.wrap(buildAwsValue())
}
object ModifySecurityGroupRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySecurityGroupRulesRequest =
      zio.aws.ec2.model.ModifySecurityGroupRulesRequest(
        groupId,
        securityGroupRules.map { item =>
          item.asEditable
        }
      )
    def groupId: SecurityGroupId
    def securityGroupRules
        : List[zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly]
    def getGroupId: ZIO[Any, Nothing, SecurityGroupId] = ZIO.succeed(groupId)
    def getSecurityGroupRules: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly
    ]] = ZIO.succeed(securityGroupRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
  ) extends zio.aws.ec2.model.ModifySecurityGroupRulesRequest.ReadOnly {
    override val groupId: SecurityGroupId =
      zio.aws.ec2.model.primitives.SecurityGroupId(impl.groupId())
    override val securityGroupRules
        : List[zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly] = impl
      .securityGroupRules()
      .asScala
      .map { item =>
        zio.aws.ec2.model.SecurityGroupRuleUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
  ): zio.aws.ec2.model.ModifySecurityGroupRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
