package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceState(
    code: Option[Integer] = None,
    name: Option[zio.aws.ec2.model.InstanceStateName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceState = {
    import InstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceState
      .builder()
      .optionallyWith(code.map(value => value: java.lang.Integer))(_.code)
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceState.ReadOnly =
    zio.aws.ec2.model.InstanceState.wrap(buildAwsValue())
}
object InstanceState {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.InstanceState] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceState = zio.aws.ec2.model
      .InstanceState(code.map(value => value), name.map(value => value))
    def code: Option[Integer]
    def name: Option[zio.aws.ec2.model.InstanceStateName]
    def getCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("code", code)
    def getName: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStateName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceState
  ) extends zio.aws.ec2.model.InstanceState.ReadOnly {
    override val code: Option[Integer] =
      scala.Option(impl.code()).map(value => value: Integer)
    override val name: Option[zio.aws.ec2.model.InstanceStateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ec2.model.InstanceStateName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceState
  ): zio.aws.ec2.model.InstanceState.ReadOnly = new Wrapper(impl)
}
