package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ExcludedInstanceType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceRequirements(
    vCpuCount: Option[zio.aws.ec2.model.VCpuCountRange] = None,
    memoryMiB: Option[zio.aws.ec2.model.MemoryMiB] = None,
    cpuManufacturers: Option[Iterable[zio.aws.ec2.model.CpuManufacturer]] =
      None,
    memoryGiBPerVCpu: Option[zio.aws.ec2.model.MemoryGiBPerVCpu] = None,
    excludedInstanceTypes: Option[Iterable[ExcludedInstanceType]] = None,
    instanceGenerations: Option[
      Iterable[zio.aws.ec2.model.InstanceGeneration]
    ] = None,
    spotMaxPricePercentageOverLowestPrice: Option[Integer] = None,
    onDemandMaxPricePercentageOverLowestPrice: Option[Integer] = None,
    bareMetal: Option[zio.aws.ec2.model.BareMetal] = None,
    burstablePerformance: Option[zio.aws.ec2.model.BurstablePerformance] = None,
    requireHibernateSupport: Option[Boolean] = None,
    networkInterfaceCount: Option[zio.aws.ec2.model.NetworkInterfaceCount] =
      None,
    localStorage: Option[zio.aws.ec2.model.LocalStorage] = None,
    localStorageTypes: Option[Iterable[zio.aws.ec2.model.LocalStorageType]] =
      None,
    totalLocalStorageGB: Option[zio.aws.ec2.model.TotalLocalStorageGB] = None,
    baselineEbsBandwidthMbps: Option[
      zio.aws.ec2.model.BaselineEbsBandwidthMbps
    ] = None,
    acceleratorTypes: Option[Iterable[zio.aws.ec2.model.AcceleratorType]] =
      None,
    acceleratorCount: Option[zio.aws.ec2.model.AcceleratorCount] = None,
    acceleratorManufacturers: Option[
      Iterable[zio.aws.ec2.model.AcceleratorManufacturer]
    ] = None,
    acceleratorNames: Option[Iterable[zio.aws.ec2.model.AcceleratorName]] =
      None,
    acceleratorTotalMemoryMiB: Option[
      zio.aws.ec2.model.AcceleratorTotalMemoryMiB
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceRequirements = {
    import InstanceRequirements.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceRequirements
      .builder()
      .optionallyWith(vCpuCount.map(value => value.buildAwsValue()))(
        _.vCpuCount
      )
      .optionallyWith(memoryMiB.map(value => value.buildAwsValue()))(
        _.memoryMiB
      )
      .optionallyWith(
        cpuManufacturers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.cpuManufacturersWithStrings)
      .optionallyWith(memoryGiBPerVCpu.map(value => value.buildAwsValue()))(
        _.memoryGiBPerVCpu
      )
      .optionallyWith(
        excludedInstanceTypes.map(value =>
          value.map { item =>
            ExcludedInstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedInstanceTypes)
      .optionallyWith(
        instanceGenerations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceGenerationsWithStrings)
      .optionallyWith(
        spotMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.spotMaxPricePercentageOverLowestPrice)
      .optionallyWith(
        onDemandMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.onDemandMaxPricePercentageOverLowestPrice)
      .optionallyWith(bareMetal.map(value => value.unwrap))(_.bareMetal)
      .optionallyWith(burstablePerformance.map(value => value.unwrap))(
        _.burstablePerformance
      )
      .optionallyWith(
        requireHibernateSupport.map(value => value: java.lang.Boolean)
      )(_.requireHibernateSupport)
      .optionallyWith(
        networkInterfaceCount.map(value => value.buildAwsValue())
      )(_.networkInterfaceCount)
      .optionallyWith(localStorage.map(value => value.unwrap))(_.localStorage)
      .optionallyWith(
        localStorageTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.localStorageTypesWithStrings)
      .optionallyWith(totalLocalStorageGB.map(value => value.buildAwsValue()))(
        _.totalLocalStorageGB
      )
      .optionallyWith(
        baselineEbsBandwidthMbps.map(value => value.buildAwsValue())
      )(_.baselineEbsBandwidthMbps)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(acceleratorCount.map(value => value.buildAwsValue()))(
        _.acceleratorCount
      )
      .optionallyWith(
        acceleratorManufacturers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorManufacturersWithStrings)
      .optionallyWith(
        acceleratorNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorNamesWithStrings)
      .optionallyWith(
        acceleratorTotalMemoryMiB.map(value => value.buildAwsValue())
      )(_.acceleratorTotalMemoryMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceRequirements.ReadOnly =
    zio.aws.ec2.model.InstanceRequirements.wrap(buildAwsValue())
}
object InstanceRequirements {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceRequirements
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceRequirements =
      zio.aws.ec2.model.InstanceRequirements(
        vCpuCount.map(value => value.asEditable),
        memoryMiB.map(value => value.asEditable),
        cpuManufacturers.map(value => value),
        memoryGiBPerVCpu.map(value => value.asEditable),
        excludedInstanceTypes.map(value => value),
        instanceGenerations.map(value => value),
        spotMaxPricePercentageOverLowestPrice.map(value => value),
        onDemandMaxPricePercentageOverLowestPrice.map(value => value),
        bareMetal.map(value => value),
        burstablePerformance.map(value => value),
        requireHibernateSupport.map(value => value),
        networkInterfaceCount.map(value => value.asEditable),
        localStorage.map(value => value),
        localStorageTypes.map(value => value),
        totalLocalStorageGB.map(value => value.asEditable),
        baselineEbsBandwidthMbps.map(value => value.asEditable),
        acceleratorTypes.map(value => value),
        acceleratorCount.map(value => value.asEditable),
        acceleratorManufacturers.map(value => value),
        acceleratorNames.map(value => value),
        acceleratorTotalMemoryMiB.map(value => value.asEditable)
      )
    def vCpuCount: Option[zio.aws.ec2.model.VCpuCountRange.ReadOnly]
    def memoryMiB: Option[zio.aws.ec2.model.MemoryMiB.ReadOnly]
    def cpuManufacturers: Option[List[zio.aws.ec2.model.CpuManufacturer]]
    def memoryGiBPerVCpu: Option[zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly]
    def excludedInstanceTypes: Option[List[ExcludedInstanceType]]
    def instanceGenerations: Option[List[zio.aws.ec2.model.InstanceGeneration]]
    def spotMaxPricePercentageOverLowestPrice: Option[Integer]
    def onDemandMaxPricePercentageOverLowestPrice: Option[Integer]
    def bareMetal: Option[zio.aws.ec2.model.BareMetal]
    def burstablePerformance: Option[zio.aws.ec2.model.BurstablePerformance]
    def requireHibernateSupport: Option[Boolean]
    def networkInterfaceCount
        : Option[zio.aws.ec2.model.NetworkInterfaceCount.ReadOnly]
    def localStorage: Option[zio.aws.ec2.model.LocalStorage]
    def localStorageTypes: Option[List[zio.aws.ec2.model.LocalStorageType]]
    def totalLocalStorageGB
        : Option[zio.aws.ec2.model.TotalLocalStorageGB.ReadOnly]
    def baselineEbsBandwidthMbps
        : Option[zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly]
    def acceleratorTypes: Option[List[zio.aws.ec2.model.AcceleratorType]]
    def acceleratorCount: Option[zio.aws.ec2.model.AcceleratorCount.ReadOnly]
    def acceleratorManufacturers
        : Option[List[zio.aws.ec2.model.AcceleratorManufacturer]]
    def acceleratorNames: Option[List[zio.aws.ec2.model.AcceleratorName]]
    def acceleratorTotalMemoryMiB
        : Option[zio.aws.ec2.model.AcceleratorTotalMemoryMiB.ReadOnly]
    def getVCpuCount
        : ZIO[Any, AwsError, zio.aws.ec2.model.VCpuCountRange.ReadOnly] =
      AwsError.unwrapOptionField("vCpuCount", vCpuCount)
    def getMemoryMiB: ZIO[Any, AwsError, zio.aws.ec2.model.MemoryMiB.ReadOnly] =
      AwsError.unwrapOptionField("memoryMiB", memoryMiB)
    def getCpuManufacturers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CpuManufacturer]] =
      AwsError.unwrapOptionField("cpuManufacturers", cpuManufacturers)
    def getMemoryGiBPerVCpu
        : ZIO[Any, AwsError, zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly] =
      AwsError.unwrapOptionField("memoryGiBPerVCpu", memoryGiBPerVCpu)
    def getExcludedInstanceTypes
        : ZIO[Any, AwsError, List[ExcludedInstanceType]] =
      AwsError.unwrapOptionField("excludedInstanceTypes", excludedInstanceTypes)
    def getInstanceGenerations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceGeneration]] =
      AwsError.unwrapOptionField("instanceGenerations", instanceGenerations)
    def getSpotMaxPricePercentageOverLowestPrice: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "spotMaxPricePercentageOverLowestPrice",
        spotMaxPricePercentageOverLowestPrice
      )
    def getOnDemandMaxPricePercentageOverLowestPrice
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "onDemandMaxPricePercentageOverLowestPrice",
      onDemandMaxPricePercentageOverLowestPrice
    )
    def getBareMetal: ZIO[Any, AwsError, zio.aws.ec2.model.BareMetal] =
      AwsError.unwrapOptionField("bareMetal", bareMetal)
    def getBurstablePerformance
        : ZIO[Any, AwsError, zio.aws.ec2.model.BurstablePerformance] =
      AwsError.unwrapOptionField("burstablePerformance", burstablePerformance)
    def getRequireHibernateSupport: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("requireHibernateSupport", requireHibernateSupport)
    def getNetworkInterfaceCount
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceCount.ReadOnly] =
      AwsError.unwrapOptionField("networkInterfaceCount", networkInterfaceCount)
    def getLocalStorage: ZIO[Any, AwsError, zio.aws.ec2.model.LocalStorage] =
      AwsError.unwrapOptionField("localStorage", localStorage)
    def getLocalStorageTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.LocalStorageType]] =
      AwsError.unwrapOptionField("localStorageTypes", localStorageTypes)
    def getTotalLocalStorageGB
        : ZIO[Any, AwsError, zio.aws.ec2.model.TotalLocalStorageGB.ReadOnly] =
      AwsError.unwrapOptionField("totalLocalStorageGB", totalLocalStorageGB)
    def getBaselineEbsBandwidthMbps: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly
    ] = AwsError.unwrapOptionField(
      "baselineEbsBandwidthMbps",
      baselineEbsBandwidthMbps
    )
    def getAcceleratorTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorType]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getAcceleratorCount
        : ZIO[Any, AwsError, zio.aws.ec2.model.AcceleratorCount.ReadOnly] =
      AwsError.unwrapOptionField("acceleratorCount", acceleratorCount)
    def getAcceleratorManufacturers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorManufacturer]] =
      AwsError.unwrapOptionField(
        "acceleratorManufacturers",
        acceleratorManufacturers
      )
    def getAcceleratorNames
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorName]] =
      AwsError.unwrapOptionField("acceleratorNames", acceleratorNames)
    def getAcceleratorTotalMemoryMiB: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AcceleratorTotalMemoryMiB.ReadOnly
    ] = AwsError.unwrapOptionField(
      "acceleratorTotalMemoryMiB",
      acceleratorTotalMemoryMiB
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirements
  ) extends zio.aws.ec2.model.InstanceRequirements.ReadOnly {
    override val vCpuCount: Option[zio.aws.ec2.model.VCpuCountRange.ReadOnly] =
      scala
        .Option(impl.vCpuCount())
        .map(value => zio.aws.ec2.model.VCpuCountRange.wrap(value))
    override val memoryMiB: Option[zio.aws.ec2.model.MemoryMiB.ReadOnly] = scala
      .Option(impl.memoryMiB())
      .map(value => zio.aws.ec2.model.MemoryMiB.wrap(value))
    override val cpuManufacturers
        : Option[List[zio.aws.ec2.model.CpuManufacturer]] = scala
      .Option(impl.cpuManufacturers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CpuManufacturer.wrap(item)
        }.toList
      )
    override val memoryGiBPerVCpu
        : Option[zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly] = scala
      .Option(impl.memoryGiBPerVCpu())
      .map(value => zio.aws.ec2.model.MemoryGiBPerVCpu.wrap(value))
    override val excludedInstanceTypes: Option[List[ExcludedInstanceType]] =
      scala
        .Option(impl.excludedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ExcludedInstanceType(item)
          }.toList
        )
    override val instanceGenerations
        : Option[List[zio.aws.ec2.model.InstanceGeneration]] = scala
      .Option(impl.instanceGenerations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceGeneration.wrap(item)
        }.toList
      )
    override val spotMaxPricePercentageOverLowestPrice: Option[Integer] = scala
      .Option(impl.spotMaxPricePercentageOverLowestPrice())
      .map(value => value: Integer)
    override val onDemandMaxPricePercentageOverLowestPrice: Option[Integer] =
      scala
        .Option(impl.onDemandMaxPricePercentageOverLowestPrice())
        .map(value => value: Integer)
    override val bareMetal: Option[zio.aws.ec2.model.BareMetal] = scala
      .Option(impl.bareMetal())
      .map(value => zio.aws.ec2.model.BareMetal.wrap(value))
    override val burstablePerformance
        : Option[zio.aws.ec2.model.BurstablePerformance] = scala
      .Option(impl.burstablePerformance())
      .map(value => zio.aws.ec2.model.BurstablePerformance.wrap(value))
    override val requireHibernateSupport: Option[Boolean] =
      scala.Option(impl.requireHibernateSupport()).map(value => value: Boolean)
    override val networkInterfaceCount
        : Option[zio.aws.ec2.model.NetworkInterfaceCount.ReadOnly] = scala
      .Option(impl.networkInterfaceCount())
      .map(value => zio.aws.ec2.model.NetworkInterfaceCount.wrap(value))
    override val localStorage: Option[zio.aws.ec2.model.LocalStorage] = scala
      .Option(impl.localStorage())
      .map(value => zio.aws.ec2.model.LocalStorage.wrap(value))
    override val localStorageTypes
        : Option[List[zio.aws.ec2.model.LocalStorageType]] = scala
      .Option(impl.localStorageTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LocalStorageType.wrap(item)
        }.toList
      )
    override val totalLocalStorageGB
        : Option[zio.aws.ec2.model.TotalLocalStorageGB.ReadOnly] = scala
      .Option(impl.totalLocalStorageGB())
      .map(value => zio.aws.ec2.model.TotalLocalStorageGB.wrap(value))
    override val baselineEbsBandwidthMbps
        : Option[zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly] = scala
      .Option(impl.baselineEbsBandwidthMbps())
      .map(value => zio.aws.ec2.model.BaselineEbsBandwidthMbps.wrap(value))
    override val acceleratorTypes
        : Option[List[zio.aws.ec2.model.AcceleratorType]] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AcceleratorType.wrap(item)
        }.toList
      )
    override val acceleratorCount
        : Option[zio.aws.ec2.model.AcceleratorCount.ReadOnly] = scala
      .Option(impl.acceleratorCount())
      .map(value => zio.aws.ec2.model.AcceleratorCount.wrap(value))
    override val acceleratorManufacturers
        : Option[List[zio.aws.ec2.model.AcceleratorManufacturer]] = scala
      .Option(impl.acceleratorManufacturers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AcceleratorManufacturer.wrap(item)
        }.toList
      )
    override val acceleratorNames
        : Option[List[zio.aws.ec2.model.AcceleratorName]] = scala
      .Option(impl.acceleratorNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AcceleratorName.wrap(item)
        }.toList
      )
    override val acceleratorTotalMemoryMiB
        : Option[zio.aws.ec2.model.AcceleratorTotalMemoryMiB.ReadOnly] = scala
      .Option(impl.acceleratorTotalMemoryMiB())
      .map(value => zio.aws.ec2.model.AcceleratorTotalMemoryMiB.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirements
  ): zio.aws.ec2.model.InstanceRequirements.ReadOnly = new Wrapper(impl)
}
