package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  InstanceEventWindowCronExpression,
  InstanceEventWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceEventWindow(
    instanceEventWindowId: Option[InstanceEventWindowId] = None,
    timeRanges: Option[
      Iterable[zio.aws.ec2.model.InstanceEventWindowTimeRange]
    ] = None,
    name: Option[String] = None,
    cronExpression: Option[InstanceEventWindowCronExpression] = None,
    associationTarget: Option[
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget
    ] = None,
    state: Option[zio.aws.ec2.model.InstanceEventWindowState] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindow = {
    import InstanceEventWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindow
      .builder()
      .optionallyWith(
        instanceEventWindowId.map(value =>
          InstanceEventWindowId.unwrap(value): java.lang.String
        )
      )(_.instanceEventWindowId)
      .optionallyWith(
        timeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeRanges)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        cronExpression.map(value =>
          InstanceEventWindowCronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .optionallyWith(associationTarget.map(value => value.buildAwsValue()))(
        _.associationTarget
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceEventWindow.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindow.wrap(buildAwsValue())
}
object InstanceEventWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindow =
      zio.aws.ec2.model.InstanceEventWindow(
        instanceEventWindowId.map(value => value),
        timeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        cronExpression.map(value => value),
        associationTarget.map(value => value.asEditable),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceEventWindowId: Option[InstanceEventWindowId]
    def timeRanges
        : Option[List[zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly]]
    def name: Option[String]
    def cronExpression: Option[InstanceEventWindowCronExpression]
    def associationTarget: Option[
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly
    ]
    def state: Option[zio.aws.ec2.model.InstanceEventWindowState]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getInstanceEventWindowId: ZIO[Any, AwsError, InstanceEventWindowId] =
      AwsError.unwrapOptionField("instanceEventWindowId", instanceEventWindowId)
    def getTimeRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly
    ]] = AwsError.unwrapOptionField("timeRanges", timeRanges)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCronExpression
        : ZIO[Any, AwsError, InstanceEventWindowCronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
    def getAssociationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly
    ] = AwsError.unwrapOptionField("associationTarget", associationTarget)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceEventWindowState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindow
  ) extends zio.aws.ec2.model.InstanceEventWindow.ReadOnly {
    override val instanceEventWindowId: Option[InstanceEventWindowId] = scala
      .Option(impl.instanceEventWindowId())
      .map(value => zio.aws.ec2.model.primitives.InstanceEventWindowId(value))
    override val timeRanges: Option[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly]
    ] = scala
      .Option(impl.timeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindowTimeRange.wrap(item)
        }.toList
      )
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val cronExpression: Option[InstanceEventWindowCronExpression] =
      scala
        .Option(impl.cronExpression())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression(value)
        )
    override val associationTarget: Option[
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly
    ] = scala
      .Option(impl.associationTarget())
      .map(value =>
        zio.aws.ec2.model.InstanceEventWindowAssociationTarget.wrap(value)
      )
    override val state: Option[zio.aws.ec2.model.InstanceEventWindowState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.InstanceEventWindowState.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindow
  ): zio.aws.ec2.model.InstanceEventWindow.ReadOnly = new Wrapper(impl)
}
