package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetPasswordDataResponse(
    instanceId: Option[String] = None,
    passwordData: Option[String] = None,
    timestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse = {
    import GetPasswordDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(passwordData.map(value => value: java.lang.String))(
        _.passwordData
      )
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly =
    zio.aws.ec2.model.GetPasswordDataResponse.wrap(buildAwsValue())
}
object GetPasswordDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetPasswordDataResponse =
      zio.aws.ec2.model.GetPasswordDataResponse(
        instanceId.map(value => value),
        passwordData.map(value => value),
        timestamp.map(value => value)
      )
    def instanceId: Option[String]
    def passwordData: Option[String]
    def timestamp: Option[DateTime]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPasswordData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("passwordData", passwordData)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse
  ) extends zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly {
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val passwordData: Option[String] =
      scala.Option(impl.passwordData()).map(value => value: String)
    override val timestamp: Option[DateTime] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse
  ): zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly = new Wrapper(impl)
}
