package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateConfigRequest(
    launchTemplateSpecification: Option[
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest
    ] = None,
    overrides: Option[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest = {
    import FleetLaunchTemplateConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.wrap(buildAwsValue())
}
object FleetLaunchTemplateConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateConfigRequest =
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest(
        launchTemplateSpecification.map(value => value.asEditable),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateSpecification: Option[
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly
    ]
    def overrides: Option[
      List[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly]
    ]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
  ) extends zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly {
    override val launchTemplateSpecification: Option[
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly
    ] = scala
      .Option(impl.launchTemplateSpecification())
      .map(value =>
        zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.wrap(value)
      )
    override val overrides: Option[
      List[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly]
    ] = scala
      .Option(impl.overrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
  ): zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
