package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{Port, ResourceArn, IpAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Explanation(
    acl: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    aclRule: Option[zio.aws.ec2.model.AnalysisAclRule] = None,
    address: Option[IpAddress] = None,
    addresses: Option[Iterable[IpAddress]] = None,
    attachedTo: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    availabilityZones: Option[Iterable[String]] = None,
    cidrs: Option[Iterable[String]] = None,
    component: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    customerGateway: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    destination: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    destinationVpc: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    direction: Option[String] = None,
    explanationCode: Option[String] = None,
    ingressRouteTable: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    internetGateway: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    loadBalancerArn: Option[ResourceArn] = None,
    classicLoadBalancerListener: Option[
      zio.aws.ec2.model.AnalysisLoadBalancerListener
    ] = None,
    loadBalancerListenerPort: Option[Port] = None,
    loadBalancerTarget: Option[zio.aws.ec2.model.AnalysisLoadBalancerTarget] =
      None,
    loadBalancerTargetGroup: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    loadBalancerTargetGroups: Option[
      Iterable[zio.aws.ec2.model.AnalysisComponent]
    ] = None,
    loadBalancerTargetPort: Option[Port] = None,
    elasticLoadBalancerListener: Option[zio.aws.ec2.model.AnalysisComponent] =
      None,
    missingComponent: Option[String] = None,
    natGateway: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    networkInterface: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    packetField: Option[String] = None,
    vpcPeeringConnection: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    port: Option[Port] = None,
    portRanges: Option[Iterable[zio.aws.ec2.model.PortRange]] = None,
    prefixList: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    protocols: Option[Iterable[String]] = None,
    routeTableRoute: Option[zio.aws.ec2.model.AnalysisRouteTableRoute] = None,
    routeTable: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    securityGroup: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    securityGroupRule: Option[zio.aws.ec2.model.AnalysisSecurityGroupRule] =
      None,
    securityGroups: Option[Iterable[zio.aws.ec2.model.AnalysisComponent]] =
      None,
    sourceVpc: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    state: Option[String] = None,
    subnet: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    subnetRouteTable: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    vpc: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    vpcEndpoint: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    vpnConnection: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    vpnGateway: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    transitGateway: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    transitGatewayRouteTable: Option[zio.aws.ec2.model.AnalysisComponent] =
      None,
    transitGatewayRouteTableRoute: Option[
      zio.aws.ec2.model.TransitGatewayRouteTableRoute
    ] = None,
    transitGatewayAttachment: Option[zio.aws.ec2.model.AnalysisComponent] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Explanation = {
    import Explanation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Explanation
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .optionallyWith(aclRule.map(value => value.buildAwsValue()))(_.aclRule)
      .optionallyWith(
        address.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addresses)
      .optionallyWith(attachedTo.map(value => value.buildAwsValue()))(
        _.attachedTo
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(customerGateway.map(value => value.buildAwsValue()))(
        _.customerGateway
      )
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(destinationVpc.map(value => value.buildAwsValue()))(
        _.destinationVpc
      )
      .optionallyWith(direction.map(value => value: java.lang.String))(
        _.direction
      )
      .optionallyWith(explanationCode.map(value => value: java.lang.String))(
        _.explanationCode
      )
      .optionallyWith(ingressRouteTable.map(value => value.buildAwsValue()))(
        _.ingressRouteTable
      )
      .optionallyWith(internetGateway.map(value => value.buildAwsValue()))(
        _.internetGateway
      )
      .optionallyWith(
        loadBalancerArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        classicLoadBalancerListener.map(value => value.buildAwsValue())
      )(_.classicLoadBalancerListener)
      .optionallyWith(
        loadBalancerListenerPort.map(value => Port.unwrap(value): Integer)
      )(_.loadBalancerListenerPort)
      .optionallyWith(loadBalancerTarget.map(value => value.buildAwsValue()))(
        _.loadBalancerTarget
      )
      .optionallyWith(
        loadBalancerTargetGroup.map(value => value.buildAwsValue())
      )(_.loadBalancerTargetGroup)
      .optionallyWith(
        loadBalancerTargetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancerTargetGroups)
      .optionallyWith(
        loadBalancerTargetPort.map(value => Port.unwrap(value): Integer)
      )(_.loadBalancerTargetPort)
      .optionallyWith(
        elasticLoadBalancerListener.map(value => value.buildAwsValue())
      )(_.elasticLoadBalancerListener)
      .optionallyWith(missingComponent.map(value => value: java.lang.String))(
        _.missingComponent
      )
      .optionallyWith(natGateway.map(value => value.buildAwsValue()))(
        _.natGateway
      )
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(packetField.map(value => value: java.lang.String))(
        _.packetField
      )
      .optionallyWith(vpcPeeringConnection.map(value => value.buildAwsValue()))(
        _.vpcPeeringConnection
      )
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .optionallyWith(prefixList.map(value => value.buildAwsValue()))(
        _.prefixList
      )
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(routeTableRoute.map(value => value.buildAwsValue()))(
        _.routeTableRoute
      )
      .optionallyWith(routeTable.map(value => value.buildAwsValue()))(
        _.routeTable
      )
      .optionallyWith(securityGroup.map(value => value.buildAwsValue()))(
        _.securityGroup
      )
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceVpc.map(value => value.buildAwsValue()))(
        _.sourceVpc
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(subnet.map(value => value.buildAwsValue()))(_.subnet)
      .optionallyWith(subnetRouteTable.map(value => value.buildAwsValue()))(
        _.subnetRouteTable
      )
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .optionallyWith(vpnGateway.map(value => value.buildAwsValue()))(
        _.vpnGateway
      )
      .optionallyWith(transitGateway.map(value => value.buildAwsValue()))(
        _.transitGateway
      )
      .optionallyWith(
        transitGatewayRouteTable.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTable)
      .optionallyWith(
        transitGatewayRouteTableRoute.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTableRoute)
      .optionallyWith(
        transitGatewayAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayAttachment)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Explanation.ReadOnly =
    zio.aws.ec2.model.Explanation.wrap(buildAwsValue())
}
object Explanation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Explanation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Explanation =
      zio.aws.ec2.model.Explanation(
        acl.map(value => value.asEditable),
        aclRule.map(value => value.asEditable),
        address.map(value => value),
        addresses.map(value => value),
        attachedTo.map(value => value.asEditable),
        availabilityZones.map(value => value),
        cidrs.map(value => value),
        component.map(value => value.asEditable),
        customerGateway.map(value => value.asEditable),
        destination.map(value => value.asEditable),
        destinationVpc.map(value => value.asEditable),
        direction.map(value => value),
        explanationCode.map(value => value),
        ingressRouteTable.map(value => value.asEditable),
        internetGateway.map(value => value.asEditable),
        loadBalancerArn.map(value => value),
        classicLoadBalancerListener.map(value => value.asEditable),
        loadBalancerListenerPort.map(value => value),
        loadBalancerTarget.map(value => value.asEditable),
        loadBalancerTargetGroup.map(value => value.asEditable),
        loadBalancerTargetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancerTargetPort.map(value => value),
        elasticLoadBalancerListener.map(value => value.asEditable),
        missingComponent.map(value => value),
        natGateway.map(value => value.asEditable),
        networkInterface.map(value => value.asEditable),
        packetField.map(value => value),
        vpcPeeringConnection.map(value => value.asEditable),
        port.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixList.map(value => value.asEditable),
        protocols.map(value => value),
        routeTableRoute.map(value => value.asEditable),
        routeTable.map(value => value.asEditable),
        securityGroup.map(value => value.asEditable),
        securityGroupRule.map(value => value.asEditable),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVpc.map(value => value.asEditable),
        state.map(value => value),
        subnet.map(value => value.asEditable),
        subnetRouteTable.map(value => value.asEditable),
        vpc.map(value => value.asEditable),
        vpcEndpoint.map(value => value.asEditable),
        vpnConnection.map(value => value.asEditable),
        vpnGateway.map(value => value.asEditable),
        transitGateway.map(value => value.asEditable),
        transitGatewayRouteTable.map(value => value.asEditable),
        transitGatewayRouteTableRoute.map(value => value.asEditable),
        transitGatewayAttachment.map(value => value.asEditable)
      )
    def acl: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def aclRule: Option[zio.aws.ec2.model.AnalysisAclRule.ReadOnly]
    def address: Option[IpAddress]
    def addresses: Option[List[IpAddress]]
    def attachedTo: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def availabilityZones: Option[List[String]]
    def cidrs: Option[List[String]]
    def component: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def customerGateway: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def destination: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def destinationVpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def direction: Option[String]
    def explanationCode: Option[String]
    def ingressRouteTable: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def internetGateway: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def loadBalancerArn: Option[ResourceArn]
    def classicLoadBalancerListener
        : Option[zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly]
    def loadBalancerListenerPort: Option[Port]
    def loadBalancerTarget
        : Option[zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly]
    def loadBalancerTargetGroup
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def loadBalancerTargetGroups
        : Option[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]]
    def loadBalancerTargetPort: Option[Port]
    def elasticLoadBalancerListener
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def missingComponent: Option[String]
    def natGateway: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def networkInterface: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def packetField: Option[String]
    def vpcPeeringConnection
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def port: Option[Port]
    def portRanges: Option[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def prefixList: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def protocols: Option[List[String]]
    def routeTableRoute
        : Option[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly]
    def routeTable: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def securityGroup: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def securityGroupRule
        : Option[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly]
    def securityGroups
        : Option[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]]
    def sourceVpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def state: Option[String]
    def subnet: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def subnetRouteTable: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpcEndpoint: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpnConnection: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpnGateway: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGateway: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGatewayRouteTable
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGatewayRouteTableRoute
        : Option[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly]
    def transitGatewayAttachment
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def getAcl
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("acl", acl)
    def getAclRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      AwsError.unwrapOptionField("aclRule", aclRule)
    def getAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("address", address)
    def getAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("addresses", addresses)
    def getAttachedTo
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getCustomerGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("customerGateway", customerGateway)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getDestinationVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("destinationVpc", destinationVpc)
    def getDirection: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("direction", direction)
    def getExplanationCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("explanationCode", explanationCode)
    def getIngressRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("ingressRouteTable", ingressRouteTable)
    def getInternetGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("internetGateway", internetGateway)
    def getLoadBalancerArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getClassicLoadBalancerListener: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly
    ] = AwsError.unwrapOptionField(
      "classicLoadBalancerListener",
      classicLoadBalancerListener
    )
    def getLoadBalancerListenerPort: ZIO[Any, AwsError, Port] = AwsError
      .unwrapOptionField("loadBalancerListenerPort", loadBalancerListenerPort)
    def getLoadBalancerTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerTarget", loadBalancerTarget)
    def getLoadBalancerTargetGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "loadBalancerTargetGroup",
        loadBalancerTargetGroup
      )
    def getLoadBalancerTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AnalysisComponent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "loadBalancerTargetGroups",
      loadBalancerTargetGroups
    )
    def getLoadBalancerTargetPort: ZIO[Any, AwsError, Port] = AwsError
      .unwrapOptionField("loadBalancerTargetPort", loadBalancerTargetPort)
    def getElasticLoadBalancerListener
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "elasticLoadBalancerListener",
        elasticLoadBalancerListener
      )
    def getMissingComponent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("missingComponent", missingComponent)
    def getNatGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("natGateway", natGateway)
    def getNetworkInterface
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getPacketField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("packetField", packetField)
    def getVpcPeeringConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpcPeeringConnection", vpcPeeringConnection)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getPortRanges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("portRanges", portRanges)
    def getPrefixList
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("prefixList", prefixList)
    def getProtocols: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField("routeTableRoute", routeTableRoute)
    def getRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("routeTable", routeTable)
    def getSecurityGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("securityGroup", securityGroup)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AnalysisComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("sourceVpc", sourceVpc)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getSubnet
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("subnet", subnet)
    def getSubnetRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("subnetRouteTable", subnetRouteTable)
    def getVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getVpcEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
    def getVpnGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpnGateway", vpnGateway)
    def getTransitGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("transitGateway", transitGateway)
    def getTransitGatewayRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTable",
        transitGatewayRouteTable
      )
    def getTransitGatewayRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableRoute",
      transitGatewayRouteTableRoute
    )
    def getTransitGatewayAttachment
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachment",
        transitGatewayAttachment
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Explanation
  ) extends zio.aws.ec2.model.Explanation.ReadOnly {
    override val acl: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      scala
        .Option(impl.acl())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val aclRule: Option[zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      scala
        .Option(impl.aclRule())
        .map(value => zio.aws.ec2.model.AnalysisAclRule.wrap(value))
    override val address: Option[IpAddress] = scala
      .Option(impl.address())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val addresses: Option[List[IpAddress]] = scala
      .Option(impl.addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.IpAddress(item)
        }.toList
      )
    override val attachedTo
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.attachedTo())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cidrs: Option[List[String]] = scala
      .Option(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val component
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.component())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val customerGateway
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.customerGateway())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val destination
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.destination())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val destinationVpc
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.destinationVpc())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val direction: Option[String] =
      scala.Option(impl.direction()).map(value => value: String)
    override val explanationCode: Option[String] =
      scala.Option(impl.explanationCode()).map(value => value: String)
    override val ingressRouteTable
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.ingressRouteTable())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val internetGateway
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.internetGateway())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val loadBalancerArn: Option[ResourceArn] = scala
      .Option(impl.loadBalancerArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val classicLoadBalancerListener
        : Option[zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly] =
      scala
        .Option(impl.classicLoadBalancerListener())
        .map(value =>
          zio.aws.ec2.model.AnalysisLoadBalancerListener.wrap(value)
        )
    override val loadBalancerListenerPort: Option[Port] = scala
      .Option(impl.loadBalancerListenerPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val loadBalancerTarget
        : Option[zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly] = scala
      .Option(impl.loadBalancerTarget())
      .map(value => zio.aws.ec2.model.AnalysisLoadBalancerTarget.wrap(value))
    override val loadBalancerTargetGroup
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.loadBalancerTargetGroup())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val loadBalancerTargetGroups
        : Option[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]] = scala
      .Option(impl.loadBalancerTargetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AnalysisComponent.wrap(item)
        }.toList
      )
    override val loadBalancerTargetPort: Option[Port] = scala
      .Option(impl.loadBalancerTargetPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val elasticLoadBalancerListener
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.elasticLoadBalancerListener())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val missingComponent: Option[String] =
      scala.Option(impl.missingComponent()).map(value => value: String)
    override val natGateway
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.natGateway())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val networkInterface
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.networkInterface())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val packetField: Option[String] =
      scala.Option(impl.packetField()).map(value => value: String)
    override val vpcPeeringConnection
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.vpcPeeringConnection())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val port: Option[Port] = scala
      .Option(impl.port())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val portRanges
        : Option[List[zio.aws.ec2.model.PortRange.ReadOnly]] = scala
      .Option(impl.portRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PortRange.wrap(item)
        }.toList
      )
    override val prefixList
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.prefixList())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val protocols: Option[List[String]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val routeTableRoute
        : Option[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly] = scala
      .Option(impl.routeTableRoute())
      .map(value => zio.aws.ec2.model.AnalysisRouteTableRoute.wrap(value))
    override val routeTable
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.routeTable())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val securityGroup
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.securityGroup())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val securityGroupRule
        : Option[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly] = scala
      .Option(impl.securityGroupRule())
      .map(value => zio.aws.ec2.model.AnalysisSecurityGroupRule.wrap(value))
    override val securityGroups
        : Option[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AnalysisComponent.wrap(item)
        }.toList
      )
    override val sourceVpc
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.sourceVpc())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val subnet: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      scala
        .Option(impl.subnet())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val subnetRouteTable
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.subnetRouteTable())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpc: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      scala
        .Option(impl.vpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpcEndpoint
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.vpcEndpoint())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpnConnection
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.vpnConnection())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpnGateway
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.vpnGateway())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGateway
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.transitGateway())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGatewayRouteTable
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.transitGatewayRouteTable())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGatewayRouteTableRoute
        : Option[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly] =
      scala
        .Option(impl.transitGatewayRouteTableRoute())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayRouteTableRoute.wrap(value)
        )
    override val transitGatewayAttachment
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.transitGatewayAttachment())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Explanation
  ): zio.aws.ec2.model.Explanation.ReadOnly = new Wrapper(impl)
}
