package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EphemeralNvmeSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport
}
object EphemeralNvmeSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport
  ): zio.aws.ec2.model.EphemeralNvmeSupport = value match {
    case software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.SUPPORTED =>
      val r = supported
      r
    case software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.EphemeralNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.EphemeralNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.EphemeralNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.SUPPORTED
  }
  case object required extends zio.aws.ec2.model.EphemeralNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport.REQUIRED
  }
}
