package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoreSuccessItem(
    snapshotId: Option[String] = None,
    availabilityZone: Option[String] = None,
    state: Option[zio.aws.ec2.model.FastSnapshotRestoreStateCode] = None,
    stateTransitionReason: Option[String] = None,
    ownerId: Option[String] = None,
    ownerAlias: Option[String] = None,
    enablingTime: Option[MillisecondDateTime] = None,
    optimizingTime: Option[MillisecondDateTime] = None,
    enabledTime: Option[MillisecondDateTime] = None,
    disablingTime: Option[MillisecondDateTime] = None,
    disabledTime: Option[MillisecondDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem = {
    import EnableFastSnapshotRestoreSuccessItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(ownerAlias.map(value => value: java.lang.String))(
        _.ownerAlias
      )
      .optionallyWith(
        enablingTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.enablingTime)
      .optionallyWith(
        optimizingTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.optimizingTime)
      .optionallyWith(
        enabledTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.enabledTime)
      .optionallyWith(
        disablingTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.disablingTime)
      .optionallyWith(
        disabledTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.disabledTime)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.wrap(buildAwsValue())
}
object EnableFastSnapshotRestoreSuccessItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem =
      zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem(
        snapshotId.map(value => value),
        availabilityZone.map(value => value),
        state.map(value => value),
        stateTransitionReason.map(value => value),
        ownerId.map(value => value),
        ownerAlias.map(value => value),
        enablingTime.map(value => value),
        optimizingTime.map(value => value),
        enabledTime.map(value => value),
        disablingTime.map(value => value),
        disabledTime.map(value => value)
      )
    def snapshotId: Option[String]
    def availabilityZone: Option[String]
    def state: Option[zio.aws.ec2.model.FastSnapshotRestoreStateCode]
    def stateTransitionReason: Option[String]
    def ownerId: Option[String]
    def ownerAlias: Option[String]
    def enablingTime: Option[MillisecondDateTime]
    def optimizingTime: Option[MillisecondDateTime]
    def enabledTime: Option[MillisecondDateTime]
    def disablingTime: Option[MillisecondDateTime]
    def disabledTime: Option[MillisecondDateTime]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FastSnapshotRestoreStateCode] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getEnablingTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("enablingTime", enablingTime)
    def getOptimizingTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("optimizingTime", optimizingTime)
    def getEnabledTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("enabledTime", enabledTime)
    def getDisablingTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("disablingTime", disablingTime)
    def getDisabledTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("disabledTime", disabledTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly {
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.FastSnapshotRestoreStateCode] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.ec2.model.FastSnapshotRestoreStateCode.wrap(value)
        )
    override val stateTransitionReason: Option[String] =
      scala.Option(impl.stateTransitionReason()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val ownerAlias: Option[String] =
      scala.Option(impl.ownerAlias()).map(value => value: String)
    override val enablingTime: Option[MillisecondDateTime] = scala
      .Option(impl.enablingTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val optimizingTime: Option[MillisecondDateTime] = scala
      .Option(impl.optimizingTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val enabledTime: Option[MillisecondDateTime] = scala
      .Option(impl.enabledTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val disablingTime: Option[MillisecondDateTime] = scala
      .Option(impl.disablingTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val disabledTime: Option[MillisecondDateTime] = scala
      .Option(impl.disabledTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
  ): zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly =
    new Wrapper(impl)
}
