package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTrunkInterfaceAssociationsResponse(
    interfaceAssociations: Option[
      Iterable[zio.aws.ec2.model.TrunkInterfaceAssociation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse = {
    import DescribeTrunkInterfaceAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse
      .builder()
      .optionallyWith(
        interfaceAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.interfaceAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeTrunkInterfaceAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse =
      zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse(
        interfaceAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def interfaceAssociations
        : Option[List[zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly]]
    def nextToken: Option[String]
    def getInterfaceAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("interfaceAssociations", interfaceAssociations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse
  ) extends zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly {
    override val interfaceAssociations
        : Option[List[zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly]] =
      scala
        .Option(impl.interfaceAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrunkInterfaceAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse
  ): zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
