package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.DescribeSecurityGroupRulesMaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupRulesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    securityGroupRuleIds: Option[Iterable[String]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeSecurityGroupRulesMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest = {
    import DescribeSecurityGroupRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        securityGroupRuleIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupRuleIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeSecurityGroupRulesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupRulesRequest.wrap(buildAwsValue())
}
object DescribeSecurityGroupRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest =
      zio.aws.ec2.model.DescribeSecurityGroupRulesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupRuleIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def securityGroupRuleIds: Option[List[String]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeSecurityGroupRulesMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getSecurityGroupRuleIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupRuleIds", securityGroupRuleIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeSecurityGroupRulesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest
  ) extends zio.aws.ec2.model.DescribeSecurityGroupRulesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val securityGroupRuleIds: Option[List[String]] = scala
      .Option(impl.securityGroupRuleIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeSecurityGroupRulesMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeSecurityGroupRulesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest
  ): zio.aws.ec2.model.DescribeSecurityGroupRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
