package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.DescribePrincipalIdFormatMaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePrincipalIdFormatRequest(
    resources: Option[Iterable[String]] = None,
    maxResults: Option[DescribePrincipalIdFormatMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest = {
    import DescribePrincipalIdFormatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        maxResults.map(value =>
          DescribePrincipalIdFormatMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrincipalIdFormatRequest.ReadOnly =
    zio.aws.ec2.model.DescribePrincipalIdFormatRequest.wrap(buildAwsValue())
}
object DescribePrincipalIdFormatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrincipalIdFormatRequest =
      zio.aws.ec2.model.DescribePrincipalIdFormatRequest(
        resources.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resources: Option[List[String]]
    def maxResults: Option[DescribePrincipalIdFormatMaxResults]
    def nextToken: Option[String]
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getMaxResults: ZIO[Any, AwsError, DescribePrincipalIdFormatMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
  ) extends zio.aws.ec2.model.DescribePrincipalIdFormatRequest.ReadOnly {
    override val resources: Option[List[String]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[DescribePrincipalIdFormatMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribePrincipalIdFormatMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
  ): zio.aws.ec2.model.DescribePrincipalIdFormatRequest.ReadOnly = new Wrapper(
    impl
  )
}
