package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfaceAttributeRequest(
    attribute: Option[zio.aws.ec2.model.NetworkInterfaceAttribute] = None,
    networkInterfaceId: NetworkInterfaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest = {
    import DescribeNetworkInterfaceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest
      .builder()
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInterfaceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest =
      zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest(
        attribute.map(value => value),
        networkInterfaceId
      )
    def attribute: Option[zio.aws.ec2.model.NetworkInterfaceAttribute]
    def networkInterfaceId: NetworkInterfaceId
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest.ReadOnly {
    override val attribute
        : Option[zio.aws.ec2.model.NetworkInterfaceAttribute] = scala
      .Option(impl.attribute())
      .map(value => zio.aws.ec2.model.NetworkInterfaceAttribute.wrap(value))
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest
  ): zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
