package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  Ipv6PoolMaxResults,
  NextToken,
  Ipv6PoolEc2Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIpv6PoolsRequest(
    poolIds: Option[Iterable[Ipv6PoolEc2Id]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[Ipv6PoolMaxResults] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest = {
    import DescribeIpv6PoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
      .builder()
      .optionallyWith(
        poolIds.map(value =>
          value.map { item =>
            Ipv6PoolEc2Id.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => Ipv6PoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpv6PoolsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIpv6PoolsRequest.wrap(buildAwsValue())
}
object DescribeIpv6PoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpv6PoolsRequest =
      zio.aws.ec2.model.DescribeIpv6PoolsRequest(
        poolIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolIds: Option[List[Ipv6PoolEc2Id]]
    def nextToken: Option[NextToken]
    def maxResults: Option[Ipv6PoolMaxResults]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getPoolIds: ZIO[Any, AwsError, List[Ipv6PoolEc2Id]] =
      AwsError.unwrapOptionField("poolIds", poolIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Ipv6PoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
  ) extends zio.aws.ec2.model.DescribeIpv6PoolsRequest.ReadOnly {
    override val poolIds: Option[List[Ipv6PoolEc2Id]] = scala
      .Option(impl.poolIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Option[Ipv6PoolMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Ipv6PoolMaxResults(value))
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
  ): zio.aws.ec2.model.DescribeIpv6PoolsRequest.ReadOnly = new Wrapper(impl)
}
