package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnAuthorizationRulesResponse(
    authorizationRules: Option[Iterable[zio.aws.ec2.model.AuthorizationRule]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse = {
    import DescribeClientVpnAuthorizationRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse
      .builder()
      .optionallyWith(
        authorizationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authorizationRules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse
      .wrap(buildAwsValue())
}
object DescribeClientVpnAuthorizationRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse =
      zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse(
        authorizationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def authorizationRules
        : Option[List[zio.aws.ec2.model.AuthorizationRule.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAuthorizationRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AuthorizationRule.ReadOnly
    ]] = AwsError.unwrapOptionField("authorizationRules", authorizationRules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse
  ) extends zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly {
    override val authorizationRules
        : Option[List[zio.aws.ec2.model.AuthorizationRule.ReadOnly]] = scala
      .Option(impl.authorizationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AuthorizationRule.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse
  ): zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly =
    new Wrapper(impl)
}
