package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeByoipCidrsResponse(
    byoipCidrs: Option[Iterable[zio.aws.ec2.model.ByoipCidr]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse = {
    import DescribeByoipCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
      .builder()
      .optionallyWith(
        byoipCidrs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.byoipCidrs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeByoipCidrsResponse.wrap(buildAwsValue())
}
object DescribeByoipCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeByoipCidrsResponse =
      zio.aws.ec2.model.DescribeByoipCidrsResponse(
        byoipCidrs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def byoipCidrs: Option[List[zio.aws.ec2.model.ByoipCidr.ReadOnly]]
    def nextToken: Option[String]
    def getByoipCidrs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ByoipCidr.ReadOnly]] =
      AwsError.unwrapOptionField("byoipCidrs", byoipCidrs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
  ) extends zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly {
    override val byoipCidrs
        : Option[List[zio.aws.ec2.model.ByoipCidr.ReadOnly]] = scala
      .Option(impl.byoipCidrs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ByoipCidr.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
  ): zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly = new Wrapper(impl)
}
