package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayConnectRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest = {
    import DeleteTransitGatewayConnectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayConnectRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayConnectRequest.wrap(buildAwsValue())
}
object DeleteTransitGatewayConnectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayConnectRequest =
      zio.aws.ec2.model
        .DeleteTransitGatewayConnectRequest(transitGatewayAttachmentId)
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayConnectRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayConnectRequest.ReadOnly =
    new Wrapper(impl)
}
