package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LaunchTemplateName, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateVersionsRequest(
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    versions: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest = {
    import DeleteLaunchTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .versions(versions.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest.wrap(buildAwsValue())
}
object DeleteLaunchTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest =
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versions
      )
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[LaunchTemplateName]
    def versions: List[String]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersions: ZIO[Any, Nothing, List[String]] = ZIO.succeed(versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest.ReadOnly {
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val versions: List[String] = impl
      .versions()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest
  ): zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
