package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNetworkInterfaceResponse(
    networkInterface: Option[zio.aws.ec2.model.NetworkInterface] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse = {
    import CreateNetworkInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse
      .builder()
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInterfaceResponse.wrap(buildAwsValue())
}
object CreateNetworkInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInterfaceResponse =
      zio.aws.ec2.model.CreateNetworkInterfaceResponse(
        networkInterface.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def networkInterface: Option[zio.aws.ec2.model.NetworkInterface.ReadOnly]
    def clientToken: Option[String]
    def getNetworkInterface
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterface.ReadOnly] =
      AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse
  ) extends zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly {
    override val networkInterface
        : Option[zio.aws.ec2.model.NetworkInterface.ReadOnly] = scala
      .Option(impl.networkInterface())
      .map(value => zio.aws.ec2.model.NetworkInterface.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse
  ): zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
