package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateManagedPrefixListRequest(
    prefixListName: String,
    entries: Option[Iterable[zio.aws.ec2.model.AddPrefixListEntry]] = None,
    maxEntries: Integer,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    addressFamily: String,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest = {
    import CreateManagedPrefixListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
      .builder()
      .prefixListName(prefixListName: java.lang.String)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .maxEntries(maxEntries: java.lang.Integer)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .addressFamily(addressFamily: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateManagedPrefixListRequest.ReadOnly =
    zio.aws.ec2.model.CreateManagedPrefixListRequest.wrap(buildAwsValue())
}
object CreateManagedPrefixListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateManagedPrefixListRequest =
      zio.aws.ec2.model.CreateManagedPrefixListRequest(
        prefixListName,
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxEntries,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addressFamily,
        clientToken.map(value => value)
      )
    def prefixListName: String
    def entries: Option[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]]
    def maxEntries: Integer
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def addressFamily: String
    def clientToken: Option[String]
    def getPrefixListName: ZIO[Any, Nothing, String] =
      ZIO.succeed(prefixListName)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddPrefixListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
    def getMaxEntries: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxEntries)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getAddressFamily: ZIO[Any, Nothing, String] = ZIO.succeed(addressFamily)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
  ) extends zio.aws.ec2.model.CreateManagedPrefixListRequest.ReadOnly {
    override val prefixListName: String = impl.prefixListName(): String
    override val entries
        : Option[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]] = scala
      .Option(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AddPrefixListEntry.wrap(item)
        }.toList
      )
    override val maxEntries: Integer = impl.maxEntries(): Integer
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val addressFamily: String = impl.addressFamily(): String
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
  ): zio.aws.ec2.model.CreateManagedPrefixListRequest.ReadOnly = new Wrapper(
    impl
  )
}
