package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateInstanceExportTaskResponse(
    exportTask: Option[zio.aws.ec2.model.ExportTask] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse = {
    import CreateInstanceExportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse
      .builder()
      .optionallyWith(exportTask.map(value => value.buildAwsValue()))(
        _.exportTask
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly =
    zio.aws.ec2.model.CreateInstanceExportTaskResponse.wrap(buildAwsValue())
}
object CreateInstanceExportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInstanceExportTaskResponse =
      zio.aws.ec2.model.CreateInstanceExportTaskResponse(
        exportTask.map(value => value.asEditable)
      )
    def exportTask: Option[zio.aws.ec2.model.ExportTask.ReadOnly]
    def getExportTask
        : ZIO[Any, AwsError, zio.aws.ec2.model.ExportTask.ReadOnly] =
      AwsError.unwrapOptionField("exportTask", exportTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse
  ) extends zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly {
    override val exportTask: Option[zio.aws.ec2.model.ExportTask.ReadOnly] =
      scala
        .Option(impl.exportTask())
        .map(value => zio.aws.ec2.model.ExportTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse
  ): zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
