package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelSpotInstanceRequestsResponse(
    cancelledSpotInstanceRequests: Option[
      Iterable[zio.aws.ec2.model.CancelledSpotInstanceRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse = {
    import CancelSpotInstanceRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse
      .builder()
      .optionallyWith(
        cancelledSpotInstanceRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cancelledSpotInstanceRequests)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly =
    zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.wrap(buildAwsValue())
}
object CancelSpotInstanceRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotInstanceRequestsResponse =
      zio.aws.ec2.model.CancelSpotInstanceRequestsResponse(
        cancelledSpotInstanceRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cancelledSpotInstanceRequests
        : Option[List[zio.aws.ec2.model.CancelledSpotInstanceRequest.ReadOnly]]
    def getCancelledSpotInstanceRequests: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CancelledSpotInstanceRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cancelledSpotInstanceRequests",
      cancelledSpotInstanceRequests
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse
  ) extends zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly {
    override val cancelledSpotInstanceRequests: Option[
      List[zio.aws.ec2.model.CancelledSpotInstanceRequest.ReadOnly]
    ] = scala
      .Option(impl.cancelledSpotInstanceRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CancelledSpotInstanceRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse
  ): zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
