package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelCapacityReservationResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse = {
    import CancelCapacityReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly =
    zio.aws.ec2.model.CancelCapacityReservationResponse.wrap(buildAwsValue())
}
object CancelCapacityReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelCapacityReservationResponse =
      zio.aws.ec2.model
        .CancelCapacityReservationResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse
  ) extends zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse
  ): zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly = new Wrapper(
    impl
  )
}
