package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BaselineEbsBandwidthMbps(
    min: Option[Integer] = None,
    max: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbps = {
    import BaselineEbsBandwidthMbps.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbps
      .builder()
      .optionallyWith(min.map(value => value: java.lang.Integer))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Integer))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly =
    zio.aws.ec2.model.BaselineEbsBandwidthMbps.wrap(buildAwsValue())
}
object BaselineEbsBandwidthMbps {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbps
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BaselineEbsBandwidthMbps =
      zio.aws.ec2.model.BaselineEbsBandwidthMbps(
        min.map(value => value),
        max.map(value => value)
      )
    def min: Option[Integer]
    def max: Option[Integer]
    def getMin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbps
  ) extends zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly {
    override val min: Option[Integer] =
      scala.Option(impl.min()).map(value => value: Integer)
    override val max: Option[Integer] =
      scala.Option(impl.max()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbps
  ): zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly = new Wrapper(impl)
}
