package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AutoPlacement {
  def unwrap: software.amazon.awssdk.services.ec2.model.AutoPlacement
}
object AutoPlacement {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AutoPlacement
  ): zio.aws.ec2.model.AutoPlacement = value match {
    case software.amazon.awssdk.services.ec2.model.AutoPlacement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AutoPlacement.ON =>
      val r = on
      r
    case software.amazon.awssdk.services.ec2.model.AutoPlacement.OFF =>
      val r = off
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AutoPlacement {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoPlacement =
      software.amazon.awssdk.services.ec2.model.AutoPlacement.UNKNOWN_TO_SDK_VERSION
  }
  case object on extends zio.aws.ec2.model.AutoPlacement {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoPlacement =
      software.amazon.awssdk.services.ec2.model.AutoPlacement.ON
  }
  case object off extends zio.aws.ec2.model.AutoPlacement {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoPlacement =
      software.amazon.awssdk.services.ec2.model.AutoPlacement.OFF
  }
}
