package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachClassicLinkVpcResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse = {
    import AttachClassicLinkVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly =
    zio.aws.ec2.model.AttachClassicLinkVpcResponse.wrap(buildAwsValue())
}
object AttachClassicLinkVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachClassicLinkVpcResponse =
      zio.aws.ec2.model
        .AttachClassicLinkVpcResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse
  ) extends zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse
  ): zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly = new Wrapper(impl)
}
