package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Affinity {
  def unwrap: software.amazon.awssdk.services.ec2.model.Affinity
}
object Affinity {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Affinity
  ): zio.aws.ec2.model.Affinity = value match {
    case software.amazon.awssdk.services.ec2.model.Affinity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Affinity.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.ec2.model.Affinity.HOST =>
      val r = host
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Affinity {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Affinity =
      software.amazon.awssdk.services.ec2.model.Affinity.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.ec2.model.Affinity {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Affinity =
      software.amazon.awssdk.services.ec2.model.Affinity.DEFAULT
  }
  case object host extends zio.aws.ec2.model.Affinity {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Affinity =
      software.amazon.awssdk.services.ec2.model.Affinity.HOST
  }
}
