package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AdditionalDetail(
    additionalDetailType: Option[String] = None,
    component: Option[zio.aws.ec2.model.AnalysisComponent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AdditionalDetail = {
    import AdditionalDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AdditionalDetail
      .builder()
      .optionallyWith(
        additionalDetailType.map(value => value: java.lang.String)
      )(_.additionalDetailType)
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AdditionalDetail.ReadOnly =
    zio.aws.ec2.model.AdditionalDetail.wrap(buildAwsValue())
}
object AdditionalDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AdditionalDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AdditionalDetail =
      zio.aws.ec2.model.AdditionalDetail(
        additionalDetailType.map(value => value),
        component.map(value => value.asEditable)
      )
    def additionalDetailType: Option[String]
    def component: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def getAdditionalDetailType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalDetailType", additionalDetailType)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AdditionalDetail
  ) extends zio.aws.ec2.model.AdditionalDetail.ReadOnly {
    override val additionalDetailType: Option[String] =
      scala.Option(impl.additionalDetailType()).map(value => value: String)
    override val component
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.component())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AdditionalDetail
  ): zio.aws.ec2.model.AdditionalDetail.ReadOnly = new Wrapper(impl)
}
