package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayVpcAttachmentResponse(
    transitGatewayVpcAttachment: Option[
      zio.aws.ec2.model.TransitGatewayVpcAttachment
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse = {
    import AcceptTransitGatewayVpcAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayVpcAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayVpcAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayVpcAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse =
      zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse(
        transitGatewayVpcAttachment.map(value => value.asEditable)
      )
    def transitGatewayVpcAttachment
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly]
    def getTransitGatewayVpcAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayVpcAttachment",
      transitGatewayVpcAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse
  ) extends zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly {
    override val transitGatewayVpcAttachment
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly] = scala
      .Option(impl.transitGatewayVpcAttachment())
      .map(value => zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse
  ): zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
