package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeAttributeName
}
object VolumeAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeAttributeName
  ): zio.aws.ec2.model.VolumeAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttributeName.AUTO_ENABLE_IO =>
      val r = autoEnableIO
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttributeName.PRODUCT_CODES =>
      val r = productCodes
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VolumeAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttributeName =
      software.amazon.awssdk.services.ec2.model.VolumeAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object autoEnableIO extends zio.aws.ec2.model.VolumeAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttributeName =
      software.amazon.awssdk.services.ec2.model.VolumeAttributeName.AUTO_ENABLE_IO
  }
  case object productCodes extends zio.aws.ec2.model.VolumeAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttributeName =
      software.amazon.awssdk.services.ec2.model.VolumeAttributeName.PRODUCT_CODES
  }
}
