package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  DateTime,
  TransitGatewayConnectPeerId,
  TransitGatewayAttachmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectPeer(
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    transitGatewayConnectPeerId: Option[TransitGatewayConnectPeerId] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayConnectPeerState] = None,
    creationTime: Option[DateTime] = None,
    connectPeerConfiguration: Option[
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration
    ] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer = {
    import TransitGatewayConnectPeer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        transitGatewayConnectPeerId.map(value =>
          TransitGatewayConnectPeerId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayConnectPeerId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        connectPeerConfiguration.map(value => value.buildAwsValue())
      )(_.connectPeerConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnectPeer.wrap(buildAwsValue())
}
object TransitGatewayConnectPeer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnectPeer =
      zio.aws.ec2.model.TransitGatewayConnectPeer(
        transitGatewayAttachmentId.map(value => value),
        transitGatewayConnectPeerId.map(value => value),
        state.map(value => value),
        creationTime.map(value => value),
        connectPeerConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def transitGatewayConnectPeerId: Option[TransitGatewayConnectPeerId]
    def state: Option[zio.aws.ec2.model.TransitGatewayConnectPeerState]
    def creationTime: Option[DateTime]
    def connectPeerConfiguration: Option[
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly
    ]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayConnectPeerId
        : ZIO[Any, AwsError, TransitGatewayConnectPeerId] =
      AwsError.unwrapOptionField(
        "transitGatewayConnectPeerId",
        transitGatewayConnectPeerId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayConnectPeerState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getConnectPeerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectPeerConfiguration",
      connectPeerConfiguration
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
  ) extends zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly {
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transitGatewayConnectPeerId
        : Option[TransitGatewayConnectPeerId] = scala
      .Option(impl.transitGatewayConnectPeerId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayConnectPeerId(value)
      )
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayConnectPeerState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayConnectPeerState.wrap(value)
      )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val connectPeerConfiguration: Option[
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly
    ] = scala
      .Option(impl.connectPeerConfiguration())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.wrap(value)
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
  ): zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly = new Wrapper(impl)
}
