package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ReservedInstancesOfferingId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetConfigurationRequest(
    instanceCount: Option[Integer] = None,
    offeringId: ReservedInstancesOfferingId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest = {
    import TargetConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest
      .builder()
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .offeringId(
        ReservedInstancesOfferingId.unwrap(offeringId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.TargetConfigurationRequest.wrap(buildAwsValue())
}
object TargetConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetConfigurationRequest =
      zio.aws.ec2.model.TargetConfigurationRequest(
        instanceCount.map(value => value),
        offeringId
      )
    def instanceCount: Option[Integer]
    def offeringId: ReservedInstancesOfferingId
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getOfferingId: ZIO[Any, Nothing, ReservedInstancesOfferingId] =
      ZIO.succeed(offeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest
  ) extends zio.aws.ec2.model.TargetConfigurationRequest.ReadOnly {
    override val instanceCount: Option[Integer] =
      scala.Option(impl.instanceCount()).map(value => value: Integer)
    override val offeringId: ReservedInstancesOfferingId =
      zio.aws.ec2.model.primitives
        .ReservedInstancesOfferingId(impl.offeringId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest
  ): zio.aws.ec2.model.TargetConfigurationRequest.ReadOnly = new Wrapper(impl)
}
