package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{CoipPoolId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Subnet(
    availabilityZone: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    availableIpAddressCount: Option[Integer] = None,
    cidrBlock: Option[String] = None,
    defaultForAz: Option[Boolean] = None,
    enableLniAtDeviceIndex: Option[Integer] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None,
    mapCustomerOwnedIpOnLaunch: Option[Boolean] = None,
    customerOwnedIpv4Pool: Option[CoipPoolId] = None,
    state: Option[zio.aws.ec2.model.SubnetState] = None,
    subnetId: Option[String] = None,
    vpcId: Option[String] = None,
    ownerId: Option[String] = None,
    assignIpv6AddressOnCreation: Option[Boolean] = None,
    ipv6CidrBlockAssociationSet: Option[
      Iterable[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation]
    ] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    subnetArn: Option[String] = None,
    outpostArn: Option[String] = None,
    enableDns64: Option[Boolean] = None,
    ipv6Native: Option[Boolean] = None,
    privateDnsNameOptionsOnLaunch: Option[
      zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Subnet
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(
        availableIpAddressCount.map(value => value: java.lang.Integer)
      )(_.availableIpAddressCount)
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(defaultForAz.map(value => value: java.lang.Boolean))(
        _.defaultForAz
      )
      .optionallyWith(
        enableLniAtDeviceIndex.map(value => value: java.lang.Integer)
      )(_.enableLniAtDeviceIndex)
      .optionallyWith(
        mapPublicIpOnLaunch.map(value => value: java.lang.Boolean)
      )(_.mapPublicIpOnLaunch)
      .optionallyWith(
        mapCustomerOwnedIpOnLaunch.map(value => value: java.lang.Boolean)
      )(_.mapCustomerOwnedIpOnLaunch)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CoipPoolId.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        assignIpv6AddressOnCreation.map(value => value: java.lang.Boolean)
      )(_.assignIpv6AddressOnCreation)
      .optionallyWith(
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockAssociationSet)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(subnetArn.map(value => value: java.lang.String))(
        _.subnetArn
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(enableDns64.map(value => value: java.lang.Boolean))(
        _.enableDns64
      )
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .optionallyWith(
        privateDnsNameOptionsOnLaunch.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptionsOnLaunch)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Subnet.ReadOnly =
    zio.aws.ec2.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Subnet = zio.aws.ec2.model.Subnet(
      availabilityZone.map(value => value),
      availabilityZoneId.map(value => value),
      availableIpAddressCount.map(value => value),
      cidrBlock.map(value => value),
      defaultForAz.map(value => value),
      enableLniAtDeviceIndex.map(value => value),
      mapPublicIpOnLaunch.map(value => value),
      mapCustomerOwnedIpOnLaunch.map(value => value),
      customerOwnedIpv4Pool.map(value => value),
      state.map(value => value),
      subnetId.map(value => value),
      vpcId.map(value => value),
      ownerId.map(value => value),
      assignIpv6AddressOnCreation.map(value => value),
      ipv6CidrBlockAssociationSet.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      subnetArn.map(value => value),
      outpostArn.map(value => value),
      enableDns64.map(value => value),
      ipv6Native.map(value => value),
      privateDnsNameOptionsOnLaunch.map(value => value.asEditable)
    )
    def availabilityZone: Option[String]
    def availabilityZoneId: Option[String]
    def availableIpAddressCount: Option[Integer]
    def cidrBlock: Option[String]
    def defaultForAz: Option[Boolean]
    def enableLniAtDeviceIndex: Option[Integer]
    def mapPublicIpOnLaunch: Option[Boolean]
    def mapCustomerOwnedIpOnLaunch: Option[Boolean]
    def customerOwnedIpv4Pool: Option[CoipPoolId]
    def state: Option[zio.aws.ec2.model.SubnetState]
    def subnetId: Option[String]
    def vpcId: Option[String]
    def ownerId: Option[String]
    def assignIpv6AddressOnCreation: Option[Boolean]
    def ipv6CidrBlockAssociationSet: Option[
      List[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly]
    ]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def subnetArn: Option[String]
    def outpostArn: Option[String]
    def enableDns64: Option[Boolean]
    def ipv6Native: Option[Boolean]
    def privateDnsNameOptionsOnLaunch
        : Option[zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getAvailableIpAddressCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableIpAddressCount", availableIpAddressCount)
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getDefaultForAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultForAz", defaultForAz)
    def getEnableLniAtDeviceIndex: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("enableLniAtDeviceIndex", enableLniAtDeviceIndex)
    def getMapPublicIpOnLaunch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mapPublicIpOnLaunch", mapPublicIpOnLaunch)
    def getMapCustomerOwnedIpOnLaunch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "mapCustomerOwnedIpOnLaunch",
        mapCustomerOwnedIpOnLaunch
      )
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CoipPoolId] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SubnetState] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getAssignIpv6AddressOnCreation: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "assignIpv6AddressOnCreation",
        assignIpv6AddressOnCreation
      )
    def getIpv6CidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociationSet",
      ipv6CidrBlockAssociationSet
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSubnetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetArn", subnetArn)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEnableDns64: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableDns64", enableDns64)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
    def getPrivateDnsNameOptionsOnLaunch: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly
    ] = AwsError.unwrapOptionField(
      "privateDnsNameOptionsOnLaunch",
      privateDnsNameOptionsOnLaunch
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Subnet
  ) extends zio.aws.ec2.model.Subnet.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val availableIpAddressCount: Option[Integer] =
      scala.Option(impl.availableIpAddressCount()).map(value => value: Integer)
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val defaultForAz: Option[Boolean] =
      scala.Option(impl.defaultForAz()).map(value => value: Boolean)
    override val enableLniAtDeviceIndex: Option[Integer] =
      scala.Option(impl.enableLniAtDeviceIndex()).map(value => value: Integer)
    override val mapPublicIpOnLaunch: Option[Boolean] =
      scala.Option(impl.mapPublicIpOnLaunch()).map(value => value: Boolean)
    override val mapCustomerOwnedIpOnLaunch: Option[Boolean] = scala
      .Option(impl.mapCustomerOwnedIpOnLaunch())
      .map(value => value: Boolean)
    override val customerOwnedIpv4Pool: Option[CoipPoolId] = scala
      .Option(impl.customerOwnedIpv4Pool())
      .map(value => zio.aws.ec2.model.primitives.CoipPoolId(value))
    override val state: Option[zio.aws.ec2.model.SubnetState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.SubnetState.wrap(value))
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val assignIpv6AddressOnCreation: Option[Boolean] = scala
      .Option(impl.assignIpv6AddressOnCreation())
      .map(value => value: Boolean)
    override val ipv6CidrBlockAssociationSet: Option[
      List[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly]
    ] = scala
      .Option(impl.ipv6CidrBlockAssociationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val subnetArn: Option[String] =
      scala.Option(impl.subnetArn()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val enableDns64: Option[Boolean] =
      scala.Option(impl.enableDns64()).map(value => value: Boolean)
    override val ipv6Native: Option[Boolean] =
      scala.Option(impl.ipv6Native()).map(value => value: Boolean)
    override val privateDnsNameOptionsOnLaunch
        : Option[zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly] =
      scala
        .Option(impl.privateDnsNameOptionsOnLaunch())
        .map(value =>
          zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Subnet
  ): zio.aws.ec2.model.Subnet.ReadOnly = new Wrapper(impl)
}
