package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartVpcEndpointServicePrivateDnsVerificationResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse = {
    import StartVpcEndpointServicePrivateDnsVerificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly =
    zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse
      .wrap(buildAwsValue())
}
object StartVpcEndpointServicePrivateDnsVerificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse =
      zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse(
        returnValue.map(value => value)
      )
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse
  ) extends zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse
  ): zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly =
    new Wrapper(impl)
}
