package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotPlacementScore(
    region: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    score: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotPlacementScore = {
    import SpotPlacementScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotPlacementScore
      .builder()
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(score.map(value => value: java.lang.Integer))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotPlacementScore.ReadOnly =
    zio.aws.ec2.model.SpotPlacementScore.wrap(buildAwsValue())
}
object SpotPlacementScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotPlacementScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotPlacementScore =
      zio.aws.ec2.model.SpotPlacementScore(
        region.map(value => value),
        availabilityZoneId.map(value => value),
        score.map(value => value)
      )
    def region: Option[String]
    def availabilityZoneId: Option[String]
    def score: Option[Integer]
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getScore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotPlacementScore
  ) extends zio.aws.ec2.model.SpotPlacementScore.ReadOnly {
    override val region: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val score: Option[Integer] =
      scala.Option(impl.score()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotPlacementScore
  ): zio.aws.ec2.model.SpotPlacementScore.ReadOnly = new Wrapper(impl)
}
