package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceConfiguration(
    serviceType: Option[Iterable[zio.aws.ec2.model.ServiceTypeDetail]] = None,
    serviceId: Option[String] = None,
    serviceName: Option[String] = None,
    serviceState: Option[zio.aws.ec2.model.ServiceState] = None,
    availabilityZones: Option[Iterable[String]] = None,
    acceptanceRequired: Option[Boolean] = None,
    managesVpcEndpoints: Option[Boolean] = None,
    networkLoadBalancerArns: Option[Iterable[String]] = None,
    gatewayLoadBalancerArns: Option[Iterable[String]] = None,
    baseEndpointDnsNames: Option[Iterable[String]] = None,
    privateDnsName: Option[String] = None,
    privateDnsNameConfiguration: Option[
      zio.aws.ec2.model.PrivateDnsNameConfiguration
    ] = None,
    payerResponsibility: Option[zio.aws.ec2.model.PayerResponsibility] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ServiceConfiguration = {
    import ServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ServiceConfiguration
      .builder()
      .optionallyWith(
        serviceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceType)
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(serviceState.map(value => value.unwrap))(_.serviceState)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        managesVpcEndpoints.map(value => value: java.lang.Boolean)
      )(_.managesVpcEndpoints)
      .optionallyWith(
        networkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkLoadBalancerArns)
      .optionallyWith(
        gatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayLoadBalancerArns)
      .optionallyWith(
        baseEndpointDnsNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.baseEndpointDnsNames)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        privateDnsNameConfiguration.map(value => value.buildAwsValue())
      )(_.privateDnsNameConfiguration)
      .optionallyWith(payerResponsibility.map(value => value.unwrap))(
        _.payerResponsibility
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ServiceConfiguration.ReadOnly =
    zio.aws.ec2.model.ServiceConfiguration.wrap(buildAwsValue())
}
object ServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ServiceConfiguration =
      zio.aws.ec2.model.ServiceConfiguration(
        serviceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceId.map(value => value),
        serviceName.map(value => value),
        serviceState.map(value => value),
        availabilityZones.map(value => value),
        acceptanceRequired.map(value => value),
        managesVpcEndpoints.map(value => value),
        networkLoadBalancerArns.map(value => value),
        gatewayLoadBalancerArns.map(value => value),
        baseEndpointDnsNames.map(value => value),
        privateDnsName.map(value => value),
        privateDnsNameConfiguration.map(value => value.asEditable),
        payerResponsibility.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceType: Option[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]]
    def serviceId: Option[String]
    def serviceName: Option[String]
    def serviceState: Option[zio.aws.ec2.model.ServiceState]
    def availabilityZones: Option[List[String]]
    def acceptanceRequired: Option[Boolean]
    def managesVpcEndpoints: Option[Boolean]
    def networkLoadBalancerArns: Option[List[String]]
    def gatewayLoadBalancerArns: Option[List[String]]
    def baseEndpointDnsNames: Option[List[String]]
    def privateDnsName: Option[String]
    def privateDnsNameConfiguration
        : Option[zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly]
    def payerResponsibility: Option[zio.aws.ec2.model.PayerResponsibility]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getServiceType: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ServiceTypeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceType", serviceType)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceState: ZIO[Any, AwsError, zio.aws.ec2.model.ServiceState] =
      AwsError.unwrapOptionField("serviceState", serviceState)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getManagesVpcEndpoints: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("managesVpcEndpoints", managesVpcEndpoints)
    def getNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("networkLoadBalancerArns", networkLoadBalancerArns)
    def getGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("gatewayLoadBalancerArns", gatewayLoadBalancerArns)
    def getBaseEndpointDnsNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("baseEndpointDnsNames", baseEndpointDnsNames)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateDnsNameConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "privateDnsNameConfiguration",
      privateDnsNameConfiguration
    )
    def getPayerResponsibility
        : ZIO[Any, AwsError, zio.aws.ec2.model.PayerResponsibility] =
      AwsError.unwrapOptionField("payerResponsibility", payerResponsibility)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ServiceConfiguration
  ) extends zio.aws.ec2.model.ServiceConfiguration.ReadOnly {
    override val serviceType
        : Option[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]] = scala
      .Option(impl.serviceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ServiceTypeDetail.wrap(item)
        }.toList
      )
    override val serviceId: Option[String] =
      scala.Option(impl.serviceId()).map(value => value: String)
    override val serviceName: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
    override val serviceState: Option[zio.aws.ec2.model.ServiceState] = scala
      .Option(impl.serviceState())
      .map(value => zio.aws.ec2.model.ServiceState.wrap(value))
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val acceptanceRequired: Option[Boolean] =
      scala.Option(impl.acceptanceRequired()).map(value => value: Boolean)
    override val managesVpcEndpoints: Option[Boolean] =
      scala.Option(impl.managesVpcEndpoints()).map(value => value: Boolean)
    override val networkLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.networkLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val gatewayLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.gatewayLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val baseEndpointDnsNames: Option[List[String]] = scala
      .Option(impl.baseEndpointDnsNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateDnsNameConfiguration
        : Option[zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly] = scala
      .Option(impl.privateDnsNameConfiguration())
      .map(value => zio.aws.ec2.model.PrivateDnsNameConfiguration.wrap(value))
    override val payerResponsibility
        : Option[zio.aws.ec2.model.PayerResponsibility] = scala
      .Option(impl.payerResponsibility())
      .map(value => zio.aws.ec2.model.PayerResponsibility.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ServiceConfiguration
  ): zio.aws.ec2.model.ServiceConfiguration.ReadOnly = new Wrapper(impl)
}
