package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupRuleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroupRuleUpdate(
    securityGroupRuleId: Option[SecurityGroupRuleId] = None,
    securityGroupRule: Option[zio.aws.ec2.model.SecurityGroupRuleRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate = {
    import SecurityGroupRuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
      .builder()
      .optionallyWith(
        securityGroupRuleId.map(value =>
          SecurityGroupRuleId.unwrap(value): java.lang.String
        )
      )(_.securityGroupRuleId)
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRuleUpdate.wrap(buildAwsValue())
}
object SecurityGroupRuleUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRuleUpdate =
      zio.aws.ec2.model.SecurityGroupRuleUpdate(
        securityGroupRuleId.map(value => value),
        securityGroupRule.map(value => value.asEditable)
      )
    def securityGroupRuleId: Option[SecurityGroupRuleId]
    def securityGroupRule
        : Option[zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly]
    def getSecurityGroupRuleId: ZIO[Any, AwsError, SecurityGroupRuleId] =
      AwsError.unwrapOptionField("securityGroupRuleId", securityGroupRuleId)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ) extends zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly {
    override val securityGroupRuleId: Option[SecurityGroupRuleId] = scala
      .Option(impl.securityGroupRuleId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupRuleId(value))
    override val securityGroupRule
        : Option[zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly] = scala
      .Option(impl.securityGroupRule())
      .map(value => zio.aws.ec2.model.SecurityGroupRuleRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ): zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly = new Wrapper(impl)
}
