package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Blob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Storage(
    awsAccessKeyId: Option[String] = None,
    bucket: Option[String] = None,
    prefix: Option[String] = None,
    uploadPolicy: Option[Blob] = None,
    uploadPolicySignature: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.S3Storage = {
    import S3Storage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.S3Storage
      .builder()
      .optionallyWith(awsAccessKeyId.map(value => value: java.lang.String))(
        _.awsAccessKeyId
      )
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        uploadPolicy.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.uploadPolicy)
      .optionallyWith(
        uploadPolicySignature.map(value => value: java.lang.String)
      )(_.uploadPolicySignature)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.S3Storage.ReadOnly =
    zio.aws.ec2.model.S3Storage.wrap(buildAwsValue())
}
object S3Storage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.S3Storage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.S3Storage = zio.aws.ec2.model.S3Storage(
      awsAccessKeyId.map(value => value),
      bucket.map(value => value),
      prefix.map(value => value),
      uploadPolicy.map(value => value),
      uploadPolicySignature.map(value => value)
    )
    def awsAccessKeyId: Option[String]
    def bucket: Option[String]
    def prefix: Option[String]
    def uploadPolicy: Option[Blob]
    def uploadPolicySignature: Option[String]
    def getAwsAccessKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccessKeyId", awsAccessKeyId)
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getUploadPolicy: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("uploadPolicy", uploadPolicy)
    def getUploadPolicySignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uploadPolicySignature", uploadPolicySignature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.S3Storage
  ) extends zio.aws.ec2.model.S3Storage.ReadOnly {
    override val awsAccessKeyId: Option[String] =
      scala.Option(impl.awsAccessKeyId()).map(value => value: String)
    override val bucket: Option[String] =
      scala.Option(impl.bucket()).map(value => value: String)
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val uploadPolicy: Option[Blob] = scala
      .Option(impl.uploadPolicy())
      .map(value =>
        zio.aws.ec2.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val uploadPolicySignature: Option[String] =
      scala.Option(impl.uploadPolicySignature()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.S3Storage
  ): zio.aws.ec2.model.S3Storage.ReadOnly = new Wrapper(impl)
}
