package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrivateDnsNameOptionsOnLaunch(
    hostnameType: Option[zio.aws.ec2.model.HostnameType] = None,
    enableResourceNameDnsARecord: Option[Boolean] = None,
    enableResourceNameDnsAAAARecord: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch = {
    import PrivateDnsNameOptionsOnLaunch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
      .builder()
      .optionallyWith(hostnameType.map(value => value.unwrap))(_.hostnameType)
      .optionallyWith(
        enableResourceNameDnsARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsARecord)
      .optionallyWith(
        enableResourceNameDnsAAAARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsAAAARecord)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly =
    zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.wrap(buildAwsValue())
}
object PrivateDnsNameOptionsOnLaunch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch =
      zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch(
        hostnameType.map(value => value),
        enableResourceNameDnsARecord.map(value => value),
        enableResourceNameDnsAAAARecord.map(value => value)
      )
    def hostnameType: Option[zio.aws.ec2.model.HostnameType]
    def enableResourceNameDnsARecord: Option[Boolean]
    def enableResourceNameDnsAAAARecord: Option[Boolean]
    def getHostnameType: ZIO[Any, AwsError, zio.aws.ec2.model.HostnameType] =
      AwsError.unwrapOptionField("hostnameType", hostnameType)
    def getEnableResourceNameDnsARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecord",
        enableResourceNameDnsARecord
      )
    def getEnableResourceNameDnsAAAARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecord",
        enableResourceNameDnsAAAARecord
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
  ) extends zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly {
    override val hostnameType: Option[zio.aws.ec2.model.HostnameType] = scala
      .Option(impl.hostnameType())
      .map(value => zio.aws.ec2.model.HostnameType.wrap(value))
    override val enableResourceNameDnsARecord: Option[Boolean] = scala
      .Option(impl.enableResourceNameDnsARecord())
      .map(value => value: Boolean)
    override val enableResourceNameDnsAAAARecord: Option[Boolean] = scala
      .Option(impl.enableResourceNameDnsAAAARecord())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
  ): zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly = new Wrapper(
    impl
  )
}
