package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase1DHGroupNumbersRequestListValue(
    value: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListValue = {
    import Phase1DHGroupNumbersRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Integer))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.ReadOnly =
    zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.wrap(buildAwsValue())
}
object Phase1DHGroupNumbersRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue =
      zio.aws.ec2.model
        .Phase1DHGroupNumbersRequestListValue(value.map(value => value))
    def value: Option[Integer]
    def getValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListValue
  ) extends zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.ReadOnly {
    override val value: Option[Integer] =
      scala.Option(impl.value()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListValue
  ): zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.ReadOnly =
    new Wrapper(impl)
}
