package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{IpamNetmaskLength, IpamPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyIpamPoolRequest(
    ipamPoolId: IpamPoolId,
    description: Option[String] = None,
    autoImport: Option[Boolean] = None,
    allocationMinNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationMaxNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationDefaultNetmaskLength: Option[IpamNetmaskLength] = None,
    clearAllocationDefaultNetmaskLength: Option[Boolean] = None,
    addAllocationResourceTags: Option[
      Iterable[zio.aws.ec2.model.RequestIpamResourceTag]
    ] = None,
    removeAllocationResourceTags: Option[
      Iterable[zio.aws.ec2.model.RequestIpamResourceTag]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest = {
    import ModifyIpamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoImport.map(value => value: java.lang.Boolean))(
        _.autoImport
      )
      .optionallyWith(
        allocationMinNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMinNetmaskLength)
      .optionallyWith(
        allocationMaxNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMaxNetmaskLength)
      .optionallyWith(
        allocationDefaultNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationDefaultNetmaskLength)
      .optionallyWith(
        clearAllocationDefaultNetmaskLength.map(value =>
          value: java.lang.Boolean
        )
      )(_.clearAllocationDefaultNetmaskLength)
      .optionallyWith(
        addAllocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addAllocationResourceTags)
      .optionallyWith(
        removeAllocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeAllocationResourceTags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamPoolRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIpamPoolRequest.wrap(buildAwsValue())
}
object ModifyIpamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamPoolRequest =
      zio.aws.ec2.model.ModifyIpamPoolRequest(
        ipamPoolId,
        description.map(value => value),
        autoImport.map(value => value),
        allocationMinNetmaskLength.map(value => value),
        allocationMaxNetmaskLength.map(value => value),
        allocationDefaultNetmaskLength.map(value => value),
        clearAllocationDefaultNetmaskLength.map(value => value),
        addAllocationResourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeAllocationResourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ipamPoolId: IpamPoolId
    def description: Option[String]
    def autoImport: Option[Boolean]
    def allocationMinNetmaskLength: Option[IpamNetmaskLength]
    def allocationMaxNetmaskLength: Option[IpamNetmaskLength]
    def allocationDefaultNetmaskLength: Option[IpamNetmaskLength]
    def clearAllocationDefaultNetmaskLength: Option[Boolean]
    def addAllocationResourceTags
        : Option[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]]
    def removeAllocationResourceTags
        : Option[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoImport", autoImport)
    def getAllocationMinNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMinNetmaskLength",
        allocationMinNetmaskLength
      )
    def getAllocationMaxNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMaxNetmaskLength",
        allocationMaxNetmaskLength
      )
    def getAllocationDefaultNetmaskLength
        : ZIO[Any, AwsError, IpamNetmaskLength] = AwsError.unwrapOptionField(
      "allocationDefaultNetmaskLength",
      allocationDefaultNetmaskLength
    )
    def getClearAllocationDefaultNetmaskLength: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "clearAllocationDefaultNetmaskLength",
        clearAllocationDefaultNetmaskLength
      )
    def getAddAllocationResourceTags: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "addAllocationResourceTags",
      addAllocationResourceTags
    )
    def getRemoveAllocationResourceTags: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "removeAllocationResourceTags",
      removeAllocationResourceTags
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
  ) extends zio.aws.ec2.model.ModifyIpamPoolRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val autoImport: Option[Boolean] =
      scala.Option(impl.autoImport()).map(value => value: Boolean)
    override val allocationMinNetmaskLength: Option[IpamNetmaskLength] = scala
      .Option(impl.allocationMinNetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationMaxNetmaskLength: Option[IpamNetmaskLength] = scala
      .Option(impl.allocationMaxNetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationDefaultNetmaskLength: Option[IpamNetmaskLength] =
      scala
        .Option(impl.allocationDefaultNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val clearAllocationDefaultNetmaskLength: Option[Boolean] = scala
      .Option(impl.clearAllocationDefaultNetmaskLength())
      .map(value => value: Boolean)
    override val addAllocationResourceTags
        : Option[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]] =
      scala
        .Option(impl.addAllocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RequestIpamResourceTag.wrap(item)
          }.toList
        )
    override val removeAllocationResourceTags
        : Option[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]] =
      scala
        .Option(impl.removeAllocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RequestIpamResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
  ): zio.aws.ec2.model.ModifyIpamPoolRequest.ReadOnly = new Wrapper(impl)
}
